#include "unit.h"

#include "tile.h"

extern tile_set_t *units;

unit_type_t unit_types[] = {
/* Name,
   Desc,
   Move Methods,
   Mov, Atk, Dfn, Sig,
   Tile */
 { "Giants",
   "Strong large warriors.",
   UNIT_MOVE_METHOD_WALK,
    10,   5,   2,   4,
    0 },
 { "Light Infantry",
   "Weak, fast foot soldiers.",
   UNIT_MOVE_METHOD_WALK,
    12,   2,   1,   3,
    0 },
 { "Heavy Infantry",
   "Strong, slow foot soldiers.",
   UNIT_MOVE_METHOD_WALK,
     8,   4,   2,   2,
     0 },
 { "Dwarven Legion",
   "Small warriors.",
   UNIT_MOVE_METHOD_WALK,
     8,   3,   2,   2,
    0 },
 { "Cavalry",
   "Strong horsemen.",
   UNIT_MOVE_METHOD_WALK,
    16,   5,   2,   2,
    0 }
};

void unit_init(unit_t *unit)
{
   unit->type = -1;
}

unit_t *unit_create(void)
{
   unit_t *unit = NULL;

   if ((unit = malloc(sizeof(unit_t))) == NULL) {
      return NULL;
   }
   unit_init(unit);

   return unit;
}

void unit_destroy(unit_t *unit)
{
   if (unit != NULL) {
      free(unit);
   }
   unit = NULL;
}

void unit_draw(const unit_t *unit, const view_t *view, float x, float y)
{
   float view_x, view_y;
   tile_t *tile;

   tile = units->tiles[unit->type];

   unit_to_view(view, x, y, &view_x, &view_y);
   draw_sprite(view->draw, tile->bitmap, (int)view_x - tile->focus_x, (int)view_y - tile->focus_y);
}

int unit_write(const unit_t *unit, FILE *file)
{
   if (fwrite((void *)unit, sizeof(unit_t), 1, file) < 1) {
      return 1;
   }

   return 0;
}

int unit_read(unit_t *unit, FILE *file)
{
   if (fread((void *)unit, sizeof(unit_t), 1, file) < 1) {
      return 1;
   }

   return 0;
}

int unit_list_reader(void *unit, FILE *file)
{
   if (unit_read((unit_t *)unit, file)) {
      return 1;
   }

   return 0;
}

int unit_list_writer(void *unit, FILE *file)
{
   if (unit_write((unit_t *)unit, file)) {
      return 1;
   }

   return 0;
}

int unit_list_read(list_t **list, FILE *file)
{
   if (list_read(list, file, sizeof(unit_t), unit_list_reader)) {
      return 1;
   }

   return 0;
}

int unit_list_write(list_t **list, FILE *file)
{
   if (list_write(list, file, unit_list_writer)) {
      return 1;
   }

   return 0;
}

unit_t *unit_list_push(list_t **list, unit_t *unit)
{
   unit_t *temp = NULL;

   if ((temp = (unit_t *)list_push_data(list, (void *)unit, NULL)) == NULL) {
      return NULL;
   }

   return temp;
}

unit_t *unit_list_pop(list_t **list, unit_t *unit)
{
   unit_t *temp = NULL;

   if ((temp = (unit_t *)list_pop_data(list, (void *)unit)) == NULL) {
      return NULL;
   }

   return temp;
}

void unit_list_clean(list_t **list)
{
   list_clean(list, unit_list_cleaner);
}

void unit_list_cleaner(void *unit)
{
   free((unit_t *)unit);
}
