#ifndef _TILE_H
#define _TILE_H

#include <allegro.h>
#include <stdio.h>

typedef struct tile_t {
   int x, y;
   int focus_x, focus_y;
   int w, h;
   BITMAP *bitmap;
} tile_t;

void tile_init(tile_t *tile);
tile_t *tile_create(void);
void tile_destroy(tile_t *tile);
int tile_create_bitmap(tile_t *tile);
void tile_destroy_bitmap(tile_t *tile);
int tile_write(const tile_t *tile, FILE *file);
int tile_read(tile_t *tile, FILE *file);

#define TILE_SET_NAME_SIZE 32
#define TILE_SET_DESC_SIZE 256
#define TILE_SET_BITMAP_SIZE 32

typedef struct tile_set_t {
   char name[TILE_SET_NAME_SIZE];
   char desc[TILE_SET_DESC_SIZE];
   char bitmap[TILE_SET_BITMAP_SIZE];
   int size;
   tile_t **tiles;
} tile_set_t;

void tile_set_init(tile_set_t *tile_set);
tile_set_t *tile_set_load(const char *filename);
int tile_set_save(tile_set_t *tile_set, const char *filename);
tile_set_t *tile_set_create(void);
void tile_set_destroy(tile_set_t *tile_set);
int tile_set_create_tiles(tile_set_t *tile_set);
void tile_set_destroy_tiles(tile_set_t *tile_set);
int tile_set_write(const tile_set_t *tile_set, FILE *file);
int tile_set_read(tile_set_t *tile_set, FILE *file);

#endif
