#ifndef _STRUCTURE_H
#define _STRUCTURE_H

#include "unit.h"

#define STRUCTURE_TYPE_NAME_SIZE 32
#define STRUCTURE_TYPE_DESC_SIZE 256

typedef struct structure_type_t {
   char name[STRUCTURE_TYPE_NAME_SIZE];
   char desc[STRUCTURE_TYPE_DESC_SIZE];
   int attack_modifier;
   int defend_modifier;
   int sight_modifier;
//   int production[UNIT_TYPE_COUNT];
} structure_type_t;

#define STRUCTURE_NAME_SIZE 32
#define STRUCTURE_DESC_SIZE 256

#define STRUCTURE_MAX 1024

typedef struct structure_t {
   char name[STRUCTURE_NAME_SIZE];
   char desc[STRUCTURE_DESC_SIZE];
   int type;
   // Adjusts by amount
   int attack_bonus;
   int defend_bonus;
   int sight_bonus;
   // Adjusts by rate
   int attack_modifier;
   int defend_modifier;
   int sight_modifier;
   int side;
   int is_razed;
} structure_t;

void structure_init(structure_t *structure);

#endif
