#ifndef _PATH_H
#define _PATH_H

#include <stdio.h>

typedef struct path_step_t {
   int x, y;
} path_step_t;

void path_step_init(path_step_t *step);
int path_step_read(path_step_t *step, FILE *file);
int path_step_write(path_step_t *step, FILE *file);

typedef struct path_t {
   int size;
   int pos;
   path_step_t *steps;
} path_t;

void path_init(path_t *path);
int path_create_steps(path_t *path);
void path_destroy_steps(path_t *path);
void path_clean(path_t *path);
int path_read(path_t *path, FILE *file);
int path_write(path_t *path, FILE *file);

#endif
