/**************************************************************************
 *                                                                        *
 * ##  /####\ #####\ #####\ /#####   /####\ ######   ##  ## /####\ #####\ *
 * ##  ##  ## ##  ## ##  ## ####     ##  ## ##       ##/\## ##  ## ##  ## *
 * ##  ##  ## #####/ ##  ##   ####   ##  ## ####     ###### ###### ###### *
 * ##  \####/ ## \## #####/ #####/   \####/ ##       ##/\## ##  ## ## ##/ *
 * ##                                                                 \## *
 * ######  By Carl Olsson   -   carljolsson@yahoo.com   -   June 2001  ## *
 *                                                                        *
 *                  http://www.geocities.com/carljolsson                  *
 *                                                                        *
 **************************************************************************/

#include <stdlib.h>
#include <allegro.h>
#include <math.h>
#include <time.h>

#include "map.h"
#include "display.h"
#include "view.h"
#include "tile.h"
#include "list.h"
#include "path.h"
#include "astar.h"
#include "gui\gui.h"
#include "gui\controls.h"
#include "gui\utility.h"
#include "gui\drawing.h"

map_t *map = NULL;
view_t view;
view_t mini_map;
display_t display;

tile_set_t *terrain = NULL;
tile_set_t *units = NULL;
tile_set_t *cursors = NULL;

int exit_flag = FALSE;

int mouse_cursor = 0;

int mini_map_flag = TRUE;

volatile int speed;

void speed_regulator(void)
{
   speed++;
}
END_OF_FUNCTION(speed_regulator);

volatile int frame;
volatile int fps;
volatile int cycle;
volatile int cps;

void persecond(void)
{
   fps = frame;
   frame = 0;
   
   cps = cycle;
   cycle = 0;
}
END_OF_FUNCTION(persecond);

int heuristic(int s_x, int s_y, int f_x, int f_y, void *data)
{
   int h;
   int d_x, d_y;

   d_x = f_x - s_x;
   d_y = f_y - s_y;

//   h = sqrt(d_x * d_x + d_y * d_y);
//   h = abs(d_x) + abs(d_y);
   h = MAX(abs(d_x), abs(d_y)) * 4;

   return h;
}

int valid(int x, int y, void *data)
{
   if (x >= 0 && x < ((map_t *)data)->w &&
       y >= 0 && y < ((map_t *)data)->h) {
      return 1;
   }

   return 0;
}

int cost(int s_x, int s_y, int f_x, int f_y, void *data)
{
   if (s_x != f_x && s_y != f_y) {
      return terrain_types[((map_t *)data)->squares[f_x][f_y].terrain.type].move_cost_diagonal;
   }
   else {
      return terrain_types[((map_t *)data)->squares[f_x][f_y].terrain.type].move_cost_straight;
   }
}

gui_menu_item_t menu1[] = {
 { "ting", NULL, menu1 },
 { "ting 2", NULL, NULL },
 { NULL, NULL, NULL },
};

gui_menu_item_t menu2[] = {
 { "thing", NULL, menu1 },
 { "thing 2", NULL, NULL },
 { NULL, NULL, NULL },
};

int button_exit_func(void)
{
   exit_flag = TRUE;

   return 0;
}

gui_button_t button_exit = {
   "Exit",
   button_exit_func,
   8, 48,
   64, 32
};

enum sex {
   SEX_MALE,
   SEX_FEMALE,
   SEX_OTHER
};

int radio_group_sex = SEX_MALE;
    
gui_radio_t radio_male = {
   &radio_group_sex,
   SEX_MALE,
   8, 88,
   16, 16
};
    
gui_radio_t radio_female = {
   &radio_group_sex,
   SEX_FEMALE,
   8, 112,
   16, 16
};
    
gui_radio_t radio_other = {
   &radio_group_sex,
   SEX_OTHER,
   8, 136,
   16, 16
};

int check_flag_alive = 1;
    
gui_check_t check_alive = {
   &check_flag_alive,
   1,
   8, 160,
   16, 16
};

gui_check_t check_mini_map = {
   &mini_map_flag,
   1,
   8, 204,
   16, 16
};

char edit_string_name[16 + 1] = "Bob";
    
gui_edit_t edit_name = {
   edit_string_name,
   16,
   -1,
   NULL,
   80, 184,
   64, 16
};
    
gui_ctrl_t window_gui[] = {
 { gui_label, &(gui_label_t) {
      "Window",
      8, 8,
      136, 32,
      NULL
    }
 },
 { gui_button, &button_exit },
 { gui_radio, &radio_male },
 { gui_label, &(gui_label_t) {
      "Male",
      24, 88,
      64, 16,
      &radio_male
    }
 },
 { gui_radio, &radio_female },
 { gui_label, &(gui_label_t) {
      "Female",
      24, 112,
      64, 16,
      &radio_female
    }
 },
 { gui_radio, &radio_other },
 { gui_label, &(gui_label_t) {
      "Other",
      24, 136,
      64, 16,
      &radio_other
    }
 },
 { gui_check, &check_alive },
 { gui_label, &(gui_label_t) {
      "Alive",
      24, 160,
      64, 16,
      &check_alive
    }
 },
 { gui_edit, &edit_name },
 { gui_label, &(gui_label_t) {
      "Name",
      8, 184,
      64, 16,
      &edit_name
    }
 },
 { gui_check, &check_mini_map },
 { gui_label, &(gui_label_t) {
      "Mini map",
      24, 204,
      64, 16,
      &check_mini_map
    }
 },
 { NULL, NULL }
};

gui_window_t main_window = {
   0, 0,
   152, 232,
   window_gui,
   0,
   0, 0
};
    
gui_ctrl_t main_gui[] = {
 { gui_window, &main_window },
 { NULL, NULL }
};

int startup(void)
{
   int i, j;
   list_t *current;
   army_t *army;
   unit_t *unit;
   int square_x, square_y;
   int army_found;
   int army_size;

   srand(time(NULL));

   allegro_init();

   if (install_timer() < 0) {
      return 1;
   }

   if (install_mouse() < 0) {
      return 1;
   }

   if (install_keyboard() < 0) {
      return 1;
   }

   /* Timers */
   LOCK_VARIABLE(speed);
   install_int_ex(speed_regulator, BPS_TO_TIMER(30));
   LOCK_VARIABLE(cycle);
   LOCK_VARIABLE(cps);
   LOCK_VARIABLE(frame);
   LOCK_VARIABLE(fps);
   install_int_ex(persecond, BPS_TO_TIMER(1));

   /* Display */
   display_set_out(&display, GFX_AUTODETECT, 640, 480, 24);
   display_set_in(&display, 640, 480, 24);
//   display_set_out(&display, GFX_AUTODETECT, 320, 240, 24);
//   display_set_in(&display, 320, 240, 24);
   display_create_buffer(&display);
   if (display_set(&display) < 0) {
      return 1;
   }
   clear(display.buffer);
   set_mouse_range(0, 0, display.in_w - 1, display.in_h - 1);
   show_mouse(NULL);

   gui_bitmap = display.buffer;
   gui_init(main_gui);

   /* Tile sets */
   if ((terrain = tile_set_load("terrain.lts")) == NULL) {
      return 1;
   }
   if ((units = tile_set_load("units.lts")) == NULL) {
      return 1;
   }
   if ((cursors = tile_set_load("cursors.lts")) == NULL) {
      return 1;
   }

   /* Create map */
   if ((map = map_create()) == NULL) {
      return 1;
   }
   map->w = 80;
   map->h = 80;
   if (map_create_squares(map)) {
      return 1;
   }

   /* Create terrain */
   textprintf(screen, font, 0, 0, 0xffffff, "Generating world...");
   if (map_generate(map)) {
      return 1;
   }

   /* Create armies */
   i = 0;
   while (i < (int)sqrt(map->w * map->h)) {
      square_x = rand() % map->w;
      square_y = rand() % map->h;
      army_found = FALSE;
      current = map->armies;
      while (current != NULL) {
         if (square_x == ((army_t *)current->data)->x &&
             square_y == ((army_t *)current->data)->y) {
            army_found = TRUE;
         }
         current = current->next;
      }
      if (army_found == FALSE) {
         if ((army = army_create()) == NULL) {
            return 1;
         }
         army_init(army);
         army->x = square_x;
         army->y = square_y;
         army->size = 0;

         /* Create units */
         army_size = rand() % 8 + 1;
         j = 0;
         while (j < army_size) {
            if ((unit = unit_create()) == NULL) {
               return 1;
            }
            unit_init(unit);
            unit->type = rand() % 5;
            army->units[j] = unit;
            if (unit_list_push(&map->units, unit) == NULL) {
               return 1;
            }
            j++;
            army->size++;
         }
         if (army_list_push(&map->armies, army) == NULL) {
            return 1;
         }
         i++;
      }
   }

   if (map_save(map, "map.lm")) return 69;
   map_destroy(map);
   if ((map = map_load("map.lm")) == NULL) return 96;

   view_init(&view);
   view_set(&view, display.buffer, 0, 0, display.in_w, display.in_w / 2, display.in_w / 2, display.in_w / 4);
   view_create_draw(&view);
   view.unit_w_pixels = 48;
   view.unit_h_pixels = 24;
   mini_map.focus_x = 0.0;
   mini_map.focus_y = 0.0;

   view_init(&mini_map);
   view_set(&mini_map, display.buffer, 0, display.in_w / 2, display.in_h - display.in_w / 2, display.in_h - display.in_w / 2, (display.in_h - display.in_w / 2) / 2, (display.in_h - display.in_w / 2) / 2);
   view_create_draw(&mini_map);
   mini_map.unit_w_pixels = (float)mini_map.w / (float)map->w;
   mini_map.unit_h_pixels = (float)mini_map.h / (float)map->h;
   mini_map.focus_x = (float)map->w / 2.0;
   mini_map.focus_y = (float)map->h / 2.0;

   return 0;
}

int play(void)
{
   float view_x, view_y;
   astar_t astar;
   army_t *cursor_army = NULL;
   army_t *selected_army = NULL;
   int cursor_x, cursor_y;
   int cursor_terrain;
   float scroll_amount;
   int game_mode;
   int selected_x, selected_y;
   float unit_x, unit_y;
   list_t *current;
   army_t *army;
   float view_x1, view_y1, view_x2, view_y2;
   int tcost;

   cursor_terrain = 0;

   selected_x = -1;
   selected_y = -1;
   cursor_x = -1;
   cursor_y = -1;

   astar_init(&astar);

   astar.data = map;
   astar.cost = cost;
   astar.estimate = heuristic;
   astar.valid = valid;

   game_mode = 1;

   while(!exit_flag) {
      while (speed > 0) {
         poll_keyboard();
         gui_update(main_gui);
         /* Update */
         poll_mouse();
         poll_keyboard();
         if (key[KEY_M]) game_mode = !game_mode;
         if (key[KEY_A]) mini_map_flag = !mini_map_flag;
         scroll_amount = 0.25;
         if (key[KEY_UP]) view.focus_y += -scroll_amount;
         if (key[KEY_DOWN]) view.focus_y += scroll_amount;
         if (key[KEY_LEFT]) view.focus_x += -scroll_amount;
         if (key[KEY_RIGHT]) view.focus_x += scroll_amount;
         if (mouse_y == 0) view.focus_y += -scroll_amount;
         if (mouse_y == display.buffer->h - 1) view.focus_y += scroll_amount;
         if (mouse_x == 0) view.focus_x += -scroll_amount;
         if (mouse_x == display.buffer->w - 1) view.focus_x += scroll_amount;

         if (key[KEY_R]) {
            if (map_generate(map)) {
               return 1;
            }
         }

         if (mouse_b & 4 || key[KEY_ESC]) {
            exit_flag = TRUE;
         }
         
         if (key[KEY_C]) {
            save_bitmap("scrcap.pcx", display.buffer, NULL);
         }

         current_map = map;

         /* Cursor */
         screen_to_view(&view, mouse_x, mouse_y, &view_x, &view_y);
         view_to_unit(&view, view_x, view_y, &unit_x, &unit_y);
         cursor_x = unit_x;
         cursor_y = unit_y;
         if (cursor_x >= 0 && cursor_x < map->w &&
             cursor_y >= 0 && cursor_y < map->h) {
            switch (game_mode) {
            case 0:
               if (mouse_x >= view.x && mouse_x < view.x + view.w &&
                   mouse_y >= view.y && mouse_y < view.y + view.h) {
                  if (mouse_b & 1) {
                     map->squares[cursor_x][cursor_y].terrain.type = cursor_terrain;
                  }
                  if (mouse_b & 2) {
                     cursor_terrain = map->squares[cursor_x][cursor_y].terrain.type;
                  }
               }
               break;
            case 1:
               if (mouse_x >= view.x && mouse_x < view.x + view.w &&
                   mouse_y >= view.y && mouse_y < view.y + view.h) {
                  if (mouse_b & 1) {
                     if (cursor_x != -1 && cursor_y != -1) {
                        cursor_army = NULL;
                        current = map->armies;
                        while (current) {
                           if (cursor_x == ((army_t *)current->data)->x &&
                               cursor_y == ((army_t *)current->data)->y) {
                              cursor_army = (army_t *)current->data;
                              break;
                           }
                           current = current->next;
                        }
                        if (selected_army &&
                            selected_army != cursor_army) {
                           if (cursor_army) {
                              if (!army_merge(cursor_army, selected_army)) {
                                 selected_army = cursor_army;
                                 selected_x = cursor_x;
                                 selected_y = cursor_y;
                              }
                           }
                           else {
                              if (selected_army->path.size > 0) {
                                 path_clean(&selected_army->path);
                                 path_init(&selected_army->path);
                              }
                              astar_search(&astar, selected_army->x, selected_army->y, cursor_x, cursor_y, &selected_army->path);
                              selected_army->path.pos = 1;
                              selected_x = cursor_x;
                              selected_y = cursor_y;
                           }
                        }
                        else if (cursor_army) {
                           selected_army = cursor_army;
                           selected_x = cursor_x;
                           selected_y = cursor_y;
                        }
                     }
                  }
                  if (mouse_b & 2) {
                     selected_army = NULL;
                     selected_x = -1;
                     selected_y = -1;
                  }
               }
               break;
            }
         }
         mouse_cursor = 0;
         if (mouse_x >= mini_map.x && mouse_x < mini_map.x + mini_map.w &&
             mouse_y >= mini_map.y && mouse_y < mini_map.y + mini_map.h) {
            if (mouse_b & 1) {
               screen_to_view(&mini_map, mouse_x, mouse_y, &view_x, &view_y);
               view_to_unit(&mini_map, view_x, view_y, &unit_x, &unit_y);
               view.focus_x = unit_x;
               view.focus_y = unit_y;
            }
         }
         current = map->armies;
         while (current) {
            army = current->data;
            if (army->path.pos < army->path.size) {
               if (army->path.pos + 1 < army->path.size &&
                   army->path.steps[army->path.pos].x != army->path.steps[army->path.pos + 1].x &&
                   army->path.steps[army->path.pos].y != army->path.steps[army->path.pos + 1].y) {
                  tcost = terrain_types[map->squares[army->path.steps[army->path.pos].x][army->path.steps[army->path.pos].y].terrain.type].move_cost_diagonal;
               }
               else {
                  tcost = terrain_types[map->squares[army->path.steps[army->path.pos].x][army->path.steps[army->path.pos].y].terrain.type].move_cost_straight;
               }
               army->sub_pos += 1.0 / tcost;
               if (army->sub_pos >= 1.0) {
                  while (army->sub_pos >= 1.0) {
                     army->x = army->path.steps[army->path.pos].x;
                     army->y = army->path.steps[army->path.pos].y;
                     army->path.pos++;
                     army->sub_pos -= 1.0;
                  }
               }
            }
            current = current->next;
         }

         if (view.focus_x < 0.0) view.focus_x = 0.0;
         if (view.focus_x > map->w) view.focus_x = map->w;
         if (view.focus_y < 0.0) view.focus_y = 0.0;
         if (view.focus_y > map->h) view.focus_y = map->h;
//         if (view.focus_x < 0.0 + view.w / view.unit_w_pixels / 2) view.focus_x = 0.0 + view.w / view.unit_w_pixels / 2;
//         if (view.focus_x > map->w - view.w / view.unit_w_pixels / 2) view.focus_x = map->w - view.w / view.unit_w_pixels / 2;
//         if (view.focus_y < 0.0 + view.h / view.unit_h_pixels / 2) view.focus_y = 0.0 + view.h / view.unit_h_pixels / 2;
//         if (view.focus_y > map->h - view.h / view.unit_h_pixels / 2) view.focus_y = map->h - view.h / view.unit_h_pixels / 2;

         speed--;
         cycle++;
      }

      /* Draw */
      clear(display.buffer);
      
      /* Draw map view */
      rect(view.draw, 0, 0, view.w - 1, view.h - 1, 0xffffff);
      map_draw(map, &view, square_draw, army_draw);
      unit_to_view(&view, cursor_x, cursor_y, &view_x, &view_y);
      rect(view.draw, view_x, view_y, view_x + view.unit_w_pixels - 1, view_y + view.unit_h_pixels - 1, 0xffffff);
      unit_to_view(&view, selected_x, selected_y, &view_x, &view_y);
      rect(view.draw, view_x, view_y, view_x + view.unit_w_pixels - 1, view_y + view.unit_h_pixels - 1, 0xff0000);
      if (selected_army != NULL) {
         unit_to_view(&view, selected_army->x, selected_army->y, &view_x, &view_y);
         rect(view.draw, view_x, view_y, view_x + view.unit_w_pixels - 1, view_y + view.unit_h_pixels - 1, 0xff0000);
      }
      
      /* Draw mini map view */
      if (mini_map_flag) {
         map_draw(map, &mini_map, mini_square_draw, mini_army_draw);
         view_to_unit(&view, 0, 0, &view_x1, &view_y1);
         view_to_unit(&view, view.w - 1, view.h - 1, &view_x2, &view_y2);
         unit_to_view(&mini_map, view_x1, view_y1, &view_x1, &view_y1);
         unit_to_view(&mini_map, view_x2, view_y2, &view_x2, &view_y2);
         set_add_blender(255, 255, 255, 255);
         drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
         rect(mini_map.draw, view_x1, view_y1, view_x2, view_y2, 0x7f7f7f);
         drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
         if (point_in_rect(mouse_x, mouse_y, mini_map.x, mini_map.y, mini_map.x + mini_map.w, mini_map.y + mini_map.h)) {
            mouse_cursor = 1;
         }
      }

      gui_draw(main_gui);
      
      textprintf(display.buffer, font, 0, 0, 0xffffff, "fps: %d, cps: %d", fps, cps);

      if (mouse_x <= 0) mouse_cursor = 4;
      if (mouse_x >= display.buffer->w - 1) mouse_cursor = 5;
      if (mouse_y <= 0) mouse_cursor = 2;
      if (mouse_y >= display.buffer->h - 1) mouse_cursor = 3;

      /* Draw mouse cursor */
      draw_sprite(display.buffer, cursors->tiles[mouse_cursor]->bitmap, mouse_x - cursors->tiles[mouse_cursor]->focus_x, mouse_y - cursors->tiles[mouse_cursor]->focus_y);

/*      a.r = 127;
      a.g = 127;
      a.b = 127;
      h.r = 191;
      h.g = 191;
      h.b = 191;
      s.r = 95;
      s.g = 95;
      s.b = 95;
      draw_circle_edge(display.buffer, 256, 256, 256, a, h, s, GUI_EDGE_STYLE_IN, GUI_EDGE_STYLE_IN, 256);*/

      vsync();
      display_update(&display);
      frame++;
   }

   return 0;
}

int shutdown(void)
{
   gui_clean(main_gui);

   remove_int(speed_regulator);

   map_destroy(map);

   display_clean(&display);

   view_clean(&view);

   tile_set_destroy(terrain);
   tile_set_destroy(units);
   tile_set_destroy(cursors);

   return 0;
}

int main(void)
{
   if (startup()) {
      return EXIT_FAILURE;
   }
   if (play()) {
      return EXIT_FAILURE;
   }
   if (shutdown()) {
      return EXIT_FAILURE;
   }

   return EXIT_SUCCESS;
}
END_OF_MAIN();
