#ifndef _LIST_H
#define _LIST_H

#include <stdio.h>

/* List type */
typedef struct list_t {
   void *data;
   struct list_t *next;
} list_t;

/* Initialise */
void list_init(list_t *list);

/* Clean */
void list_clean(list_t **list, void (*cleaner)(void *data));

/* Push/pop */
list_t *list_push(list_t **list, list_t *node, list_t *pos);
list_t *list_pop(list_t **list, list_t *node);
void *list_push_data(list_t **list, void *data, list_t *pos);
void *list_pop_data(list_t **list, void *data);

/* File I/O */
int list_read(list_t **list, FILE *file, int size, int (*reader)(void *data, FILE *file));
int list_write(list_t **list, FILE *file, int (*writer)(void *data, FILE *file));

/* General */
int list_count(list_t **list);
int list_pos(list_t **list, list_t *node);
int list_data_pos(list_t **list, void *data);

#endif
