#include "perlin.h"

#include <math.h>
#include <stdio.h>

#include "interp.h"

float noise(int x, int y)
{
   int n;

   n = x + y * 57;
   n = (n<<13) ^ n;
   return ( 1.0 - ( (n * (n * n * 15731 + 789221) + 1376312589) & 0x7fffffff) / 1073741824.0);
}

double perlin_noise(double (*method)(double *samp, double pos), int interp_samps, int samp_offset, double *pos, double persistence, int octaves, double *buf)
{
   int i, j, k;
   double total;
   double frequency;
   double amplitude;
   int integer_x, integer_y;
   double fractional_x, fractional_y;
   double res;
   double ox, oy;
   double p[2];

   total = 0;
   for (i = 0; i < octaves; i++) {
      frequency = pow(2, i);
      amplitude = pow(persistence, i);

      ox = pos[0] * frequency;
      oy = pos[1] * frequency;

      integer_x    = (int)ox;
      fractional_x = ox - integer_x;
      integer_y    = (int)oy;
      fractional_y = oy - integer_y;

      for (j = 0; j < interp_samps; j++) {
         for (k = 0; k < interp_samps; k++) {
            buf[j * interp_samps + k] = noise(integer_x + k + samp_offset, integer_y + j + samp_offset);
         }
      }

      p[0] = fractional_x;
      p[1] = fractional_y;

      res = poly_interp(method, 2, interp_samps, buf, p, NULL);
      total = total + res * amplitude;
   }

   return total;
}
