#include "hmap.h"

#include <stdlib.h>
#include <math.h>

void hmap_init(hmap_t *hmap)
{
   hmap->w = 0;
   hmap->h = 0;
   hmap->squares = NULL;
}

void hmap_destroy_squares(hmap_t *hmap)
{
   int i;

   if (hmap->squares != NULL) {
      for (i = 0; i < hmap->w; i++) {
         free(hmap->squares[i]);
      }
      free(hmap->squares);
      hmap->squares = NULL;
   }
}

int hmap_create_squares(hmap_t *hmap)
{
   int i, j;

   if ((hmap->squares = malloc(sizeof(float *) * hmap->w)) != NULL) {
      for (i = 0; i < hmap->w; i++) {
         if ((hmap->squares[i] = malloc(sizeof(float) * hmap->h)) != NULL) {
            for (j = 0; j < hmap->h; j++) {
               hmap->squares[i][j] = 0.0;
            }
         }
         else {
            free(hmap->squares);
            hmap->squares = NULL;
            return 1;
         }
      }
   }
   else {
      return 1;
   }

   return 0;
}

void hmap_clean(hmap_t *hmap)
{
   hmap_destroy_squares(hmap);
}

int contain_rect(int *x, int *y, int x_extent, int y_extent, int method)
{
   switch (method) {
   case CONTAIN_STRICT:
      if (*x < 0 || *x >= x_extent ||
          *y < 0 || *y >= y_extent) {
         return FALSE;
      }
      break;
   case CONTAIN_EXTEND:
      if (*x < 0) *x = 0;
      if (*x > x_extent - 1) *x = x_extent - 1;
      if (*y < 0) *y = 0;
      if (*y > y_extent - 1) *y = y_extent - 1;
      break;
   case CONTAIN_WRAP:
      while (*x < 0) *x += x_extent;
      while (*x >= x_extent) *x -= x_extent;
      while (*y < 0) *y += y_extent;
      while (*y >= y_extent) *y -= y_extent;
      break;
   case CONTAIN_REVERSE:
//      while (*x < 0 || *x >= x_extent) {
      while (abs(*x) >= x_extent) {
         *x += (*x < 0) ? x_extent : -x_extent;
         *x = -*x;
      }
      if (*x < 0) *x = -*x;
//      while (*y < 0 || *y >= y_extent) {
      while (abs(*y) >= y_extent) {
         *y += (*y < 0) ? y_extent : -y_extent;
         *y = -*y;
      }
      if (*y < 0) *y = -*y;
      break;
   }

   return TRUE;
}

