#ifndef _HMAP_GENERATE_H
#define _HMAP_GENERATE_H

#include "hmap.h"

typedef void (*hmap_collager_t)(hmap_t *hmap, float x, float y, float size, float power, int contain);

void inverse_hemisphere_collager(hmap_t *hmap, float x, float y, float size, float scale, int contain);
void hemisphere_collager(hmap_t *hmap, float x, float y, float size, float scale, int contain);
void pyramid_collager(hmap_t *hmap, float x, float y, float size, float scale, int contain);
void diamond_collager(hmap_t *hmap, float x, float y, float size, float scale, int contain);
void fault_collager(hmap_t *hmap, float x, float y, float size, float scale, int contain);
void crater_collager(hmap_t *hmap, float x, float y, float size, float scale, int contain);
void cone_collager(hmap_t *hmap, float x, float y, float size, float scale, int contain);
void square_collager(hmap_t *hmap, float x, float y, float size, float scale, int contain);
void circle_collager(hmap_t *hmap, float x, float y, float size, float scale, int contain);
void bump_collager(hmap_t *hmap, float x, float y, float size, float scale, int contain);
void peak_collager(hmap_t *hmap, float x, float y, float size, float power, int contain);
void point_collager(hmap_t *hmap, float x, float y, float size, float scale, int contain);

void hmap_collage(hmap_t *hmap, hmap_collager_t method, int number, float size, int contain);
void hmap_collage_reduce(hmap_t *hmap, hmap_collager_t method, int number, float size, int contain);
void hmap_subdivide(hmap_t *hmap, float x, float y, float w, float h, float range, float roughness);
void hmap_subdivision(hmap_t *hmap, float range, float roughness);
void hmap_faulting(hmap_t *hmap, int number, float range);
void hmap_frequency_composition(hmap_t *hmap, int number);
void hmap_perlin(hmap_t *hmap, double persistence, int octaves);
void hmap_deposition2(hmap_t *hmap, hmap_collager_t method, int number, int size, double dist, double bsize, int contain);
void hmap_deposition3(hmap_t *hmap, hmap_collager_t method, int number, int size, double dist, double bsize, int contain);
void hmap_deposition4(hmap_t *hmap, hmap_collager_t method, int number, int size, double dist, double bsize, int contain);

#endif
