#include "colmap.h"

#include "interp.h"

#define LIM(x, a, b) (x < a ? a : (x > b ? b : x))

void colmap_get(colmap_t *colmap, double (*method)(double *samp, double pos), int interp_samps, int samp_offset, double pos, int *r, int *g, int *b, double *buf)
{
   int col;
   int pre_col, post_col;
   double p;
   int size;
   int i;

   pre_col = -1;
   post_col = -1;

   /* Find size of colour map */
   size = 0;
   while (colmap[size].pos >= 0.0) {
      size++;
   }

   for (col = 0; col < size; col++) {
      if (colmap[col].pos >= pos) {
         pre_col = col - 1;
         post_col = col;
         break;
      }
   }

   if (post_col > -1) {
      p = (pos - colmap[pre_col].pos) / (colmap[post_col].pos - colmap[pre_col].pos);
      for (i = 0; i < interp_samps; i++) {
         col = i + samp_offset + pre_col;
         if (col < 0) col = 0;
         if (col > size - 1) col = size - 1;
         (buf + 0 * interp_samps)[i] = colmap[col].r;
         (buf + 1 * interp_samps)[i] = colmap[col].g;
         (buf + 2 * interp_samps)[i] = colmap[col].b;
      }
      *r = LIM((int)method((buf + 0 * interp_samps), p), 0, 255);
      *g = LIM((int)method((buf + 1 * interp_samps), p), 0, 255);
      *b = LIM((int)method((buf + 2 * interp_samps), p), 0, 255);
   }
}

