#ifndef _GUI_DRAWING_H
#define _GUI_DRAWING_H



#include <allegro.h>

#define GUI_EDGE_STYLE_NONE 1
#define GUI_EDGE_STYLE_FLAT 2
#define GUI_EDGE_STYLE_IN   3
#define GUI_EDGE_STYLE_OUT  4

#define GUI_LEFT   0
#define GUI_CENTRE 1
#define GUI_RIGHT  2
#define GUI_TOP    0
#define GUI_MIDDLE 1
#define GUI_BOTTOM 2
/*
typedef struct gui_draw_info_t {
   RGB edge_colour;
   RGB edge_highlight;
   RGB edge_shadow;
   RGB edge_selected_colour;
   RGB edge_selected_highlight;
   RGB edge_selected_shadow;
//   BITMAP *edge_texture;
   RGB area_colour;
   RGB area_highlight;
   RGB area_shadow;
   RGB area_selected_colour;
   RGB area_selected_highlight;
   RGB area_selected_shadow;
//   BITMAP *area_texture;
   RGB font_colour;
   RGB font_selected_colour;
} gui_draw_info_t;
*/
typedef struct gui_draw_info_t {
   RGB button_area;
   RGB button_highlight;
   RGB button_shadow;
   RGB button_text;
   RGB field_area;
   RGB field_highlight;
   RGB field_shadow;
   RGB field_text;
} gui_draw_info_t;

typedef struct gui_colour_info_t {
   RGB flat;
   RGB highlight;
   RGB shadow;
   RGB text;
} gui_colour_info_t;

typedef struct gui_edge_info_t {
   int thickness;
   BITMAP **texture;
} gui_edge_info_t;

typedef struct gui_area_info_t {
   BITMAP **texture;
} gui_area_info_t;

typedef struct gui_text_info_t {
   FONT **font;
   BITMAP **texture;
} gui_text_info_t;

extern gui_draw_info_t draw_info;

extern gui_draw_info_t *gui_draw_info;

void align(const int x1, const int y1, const int x2, const int y2, const int w, const int h, const int halign, const int valign, int * const x, int * const y);

void draw_text(BITMAP *dest, const FONT *fnt, const int x1, const int y1, const int x2, const int y2, const RGB colour, const int halign, const int valign, const char *str, const int type, const int style);
void gui_text(const FONT *fnt, const int x1, const int y1, const int x2, const int y2, const int halign, const int valign, const char *str, const int type, const int style);
void draw_edge(BITMAP *dest, const int x1, const int y1, const int x2, const int y2, const RGB colour, const RGB highlight, const RGB shadow, const int type, const int style, const int width);
void gui_edge(const int x1, const int y1, const int x2, const int y2, const int type, const int style);
void draw_area(BITMAP *dest, const int x1, const int y1, const int x2, const int y2, const RGB colour, const RGB highlight, const RGB shadow, const int type, const int style);
void gui_area(const int x1, const int y1, const int x2, const int y2, const int type, const int style);
void gui_box(const int x1, const int y1, const int x2, const int y2, const int type, const int area_style, const int edge_style);



#endif
