#ifndef _GUI_CONTROLS_H
#define _GUI_CONTROLS_H

#include "gui.h"

typedef struct gui_menu_item_t {
   char *text;
   int (*func)(struct gui_menu_item_t *menu);
   struct gui_menu_item_t *child;
} gui_menu_item_t;

typedef struct gui_menu_t {
   char *text;
   int x, y;
   int w, h;
   gui_menu_item_t *child;
} gui_menu_t;

typedef struct gui_button_t {
   char *text;
   int (*func)(void);
   int x, y;
   int w, h;
} gui_button_t;

typedef struct gui_radio_t {
   int *group;
   int index;
   int x, y;
   int w, h;
} gui_radio_t;

typedef struct gui_check_t {
   int *flag;
   int bit;
   int x, y;
   int w, h;
} gui_check_t;

typedef struct gui_edit_t {
   char *text;
   int length;
   int cursor;
   char *buffer;
   int x, y;
   int w, h;
} gui_edit_t;

typedef struct gui_label_t {
   char *text;
   int x, y;
   int w, h;
   void *attached;
} gui_label_t;

#define GUI_CTRL_WINDOW_FLG_MODAL 1

typedef struct gui_window_t {
   int x, y;
   int w, h;
   gui_ctrl_t *gui;
   int flags;
   int old_mouse_x, old_mouse_y;
} gui_window_t;

int gui_button(struct gui_ctrl_t *ctrl, int msg, int mod);
int gui_radio(struct gui_ctrl_t *ctrl, int msg, int mod);
int gui_check(struct gui_ctrl_t *ctrl, int msg, int mod);
int gui_edit(struct gui_ctrl_t *ctrl, int msg, int mod);
int gui_label(struct gui_ctrl_t *ctrl, int msg, int mod);
int gui_window(struct gui_ctrl_t *ctrl, int msg, int mod);

#endif
