#include "controls.h"

#include <allegro.h>
#include <ctype.h>
#include <string.h>

#include "gui.h"
#include "drawing.h"
#include "utility.h"

int gui_label(struct gui_ctrl_t *ctrl, int msg, int mod)
{
   gui_label_t *me;
   int x, y, w, h;
   int x1, y1, x2, y2;
   int old_parent_x, old_parent_y;
   int ret;
   clip_t clip;

   me = (gui_label_t *)ctrl->data;
                                          
   old_parent_x = gui_parent_x;
   old_parent_y = gui_parent_y;

   x = me->x + gui_parent_x;
   y = me->y + gui_parent_y;
   w = me->w;
   h = me->h;

   gui_parent_x = x;
   gui_parent_y = y;

   x1 = x;
   y1 = y;
   x2 = x + w - 1;
   y2 = y + h - 1;

   ret = GUI_RET_NONE;

   switch (msg) {
   case GUI_MSG_INIT:
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_CLEAN:
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_DRAW:
      /* Clip */
      clip_save(&clip, gui_bitmap);
      set_clip(gui_bitmap, x1, y1, x2, y2);

      gui_draw_info = &draw_info;
      gui_text(font, x1, y1, x2, y2, GUI_CENTRE, GUI_MIDDLE, me->text, 0, 0);

      /* Unclip */
      clip_load(&clip, gui_bitmap);

      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_CLICK:
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_KEY:
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_CHAR:
      ret = GUI_RET_NONE;
      break;
   }

   if (me->attached != NULL) {
//      ret = gui_ctrl_msg(me->attached, msg, mod);
   }

   gui_parent_x = old_parent_x;
   gui_parent_y = old_parent_y;

   return ret;
}

int gui_menu(struct gui_ctrl_t *ctrl, int msg, int mod)
{
   gui_menu_t *me;
   int x, y, w, h;
   int x1, y1, x2, y2;
   int old_parent_x, old_parent_y;
   int ret;

   me = (gui_menu_t *)ctrl->data;

   old_parent_x = gui_parent_x;
   old_parent_y = gui_parent_y;

   x = me->x + gui_parent_x;
   y = me->y + gui_parent_y;
   w = me->w;
   h = me->h;

   gui_parent_x = x;
   gui_parent_y = y;

   x1 = x;
   y1 = y;
   x2 = x + w - 1;
   y2 = y + h - 1;

   ret = GUI_RET_NONE;

   switch (msg) {
   case GUI_MSG_INIT:
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_CLEAN:
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_DRAW:
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_CLICK:
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_KEY:
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_CHAR:
      ret = GUI_RET_NONE;
      break;
   }

   gui_parent_x = old_parent_x;
   gui_parent_y = old_parent_y;

   return ret;
}

int gui_button(struct gui_ctrl_t *ctrl, int msg, int mod)
{
   gui_button_t *me;
   int x, y, w, h;
   int x1, y1, x2, y2;
   int old_parent_x, old_parent_y;
   int ret;
   int style;
   clip_t clip;

   me = (gui_button_t *)ctrl->data;

   old_parent_x = gui_parent_x;
   old_parent_y = gui_parent_y;

   x = me->x + gui_parent_x;
   y = me->y + gui_parent_y;
   w = me->w;
   h = me->h;

   gui_parent_x = x;
   gui_parent_y = y;

   x1 = x;
   y1 = y;
   x2 = x + w - 1;
   y2 = y + h - 1;

   ret = GUI_RET_NONE;

   switch (msg) {
   case GUI_MSG_INIT:
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_CLEAN:
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_DRAW:
      clip_save(&clip, gui_bitmap);
      set_clip(gui_bitmap, x1, y1, x2, y2);
      gui_draw_info = &draw_info;
      if ((gui_mouse_info.action == GUI_MOUSE_ACTION_DOWN ||
          gui_mouse_info.action == GUI_MOUSE_ACTION_HOLD) &&
          gui_mouse_ctrl == ctrl) {
         style = GUI_EDGE_STYLE_IN;
      }
      else {
         style = GUI_EDGE_STYLE_OUT;
      }
      gui_box(x1, y1, x2, y2, 0, 0, style);
      gui_text(font, x1, y1, x2, y2, GUI_CENTRE, GUI_MIDDLE, me->text, 0, 0);
      clip_load(&clip, gui_bitmap);
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_CLICK:
      if (point_in_rect(mouse_x, mouse_y, x1, y1, x2, y2)) {
         if (gui_mouse_ctrl == ctrl || gui_mouse_ctrl == NULL) {
            if (gui_mouse_ctrl == ctrl) {
               if (gui_mouse_info.action == GUI_MOUSE_ACTION_UP) {
                  if (me->func) {
                     me->func();
                  }
               }
            }
            if (gui_mouse_info.action == GUI_MOUSE_ACTION_DOWN) {
               gui_mouse_ctrl = ctrl;
            }
         }
      }
      else {
         if (gui_mouse_info.action == GUI_MOUSE_ACTION_UP ||
             gui_mouse_info.action == GUI_MOUSE_ACTION_NONE) {
            if (gui_mouse_ctrl == ctrl) {
               gui_mouse_ctrl = NULL;
            }
         }
      }
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_KEY:
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_CHAR:
      ret = GUI_RET_NONE;
      break;
   }

   gui_parent_x = old_parent_x;
   gui_parent_y = old_parent_y;

   return ret;
}

int gui_radio(struct gui_ctrl_t *ctrl, int msg, int mod)
{
   gui_radio_t *me;
   int x, y, w, h;
   int x1, y1, x2, y2;
   int old_parent_x, old_parent_y;
   int ret;
   clip_t clip;

   me = (gui_radio_t *)ctrl->data;

   old_parent_x = gui_parent_x;
   old_parent_y = gui_parent_y;

   x = me->x + gui_parent_x;
   y = me->y + gui_parent_y;
   w = me->w;
   h = me->h;

   gui_parent_x = x;
   gui_parent_y = y;

   x1 = x;
   y1 = y;
   x2 = x + w - 1;
   y2 = y + h - 1;

   ret = GUI_RET_NONE;

   switch (msg) {
   case GUI_MSG_INIT:
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_CLEAN:
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_DRAW:
      clip_save(&clip, gui_bitmap);
      set_clip(gui_bitmap, x1, y1, x2, y2);
      gui_draw_info = &draw_info;
      gui_box(x1, y1, x2, y2, 1, 1, GUI_EDGE_STYLE_IN);
      if (*me->group == me->index) {
//         gui_box(x1 + 3, y1 + 3, x2 - 3, y2 - 3, 0, 0, GUI_EDGE_STYLE_OUT, 1);
//         rectfill(gui_bitmap, x1 + 3, y1 + 3, x2 - 3, y2 - 3, 0x000000);
//         ellipsefill(gui_bitmap, (x1 + x2) / 2, (y1 + y2) / 2, (x2 - x1) / 2 / 2, (y2 - y1) / 2 / 2, 0x000000);
         gui_box(x1 + ((x2 - x1) / 4), y1 + ((y2 - y1) / 4), x2 - ((x2 - x1) / 4), y2 - ((y2 - y1) / 4), 0, 0, GUI_EDGE_STYLE_OUT);
      }
      else {
      }
      clip_load(&clip, gui_bitmap);
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_CLICK:
      if (point_in_rect(mouse_x, mouse_y, x1, y1, x2, y2)) {
         if (gui_mouse_ctrl == ctrl || gui_mouse_ctrl == NULL) {
            if (gui_mouse_ctrl == ctrl) {
               if (gui_mouse_info.action == GUI_MOUSE_ACTION_UP) {
                  *me->group = me->index;
               }
            }
            if (gui_mouse_info.action == GUI_MOUSE_ACTION_DOWN) {
               gui_mouse_ctrl = ctrl;
            }
         }
      }
      else {
         if (gui_mouse_info.action == GUI_MOUSE_ACTION_UP ||
             gui_mouse_info.action == GUI_MOUSE_ACTION_NONE) {
            if (gui_mouse_ctrl == ctrl) {
               gui_mouse_ctrl = NULL;
            }
         }
      }
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_KEY:
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_CHAR:
      ret = GUI_RET_NONE;
      break;
   }

   gui_parent_x = old_parent_x;
   gui_parent_y = old_parent_y;

   return ret;
}

int gui_check(struct gui_ctrl_t *ctrl, int msg, int mod)
{
   gui_check_t *me;
   int x, y, w, h;
   int x1, y1, x2, y2;
   int old_parent_x, old_parent_y;
   int ret;
   clip_t clip;

   me = (gui_check_t *)ctrl->data;

   old_parent_x = gui_parent_x;
   old_parent_y = gui_parent_y;

   x = me->x + gui_parent_x;
   y = me->y + gui_parent_y;
   w = me->w;
   h = me->h;

   gui_parent_x = x;
   gui_parent_y = y;

   x1 = x;
   y1 = y;
   x2 = x + w - 1;
   y2 = y + h - 1;

   ret = GUI_RET_NONE;

   switch (msg) {
   case GUI_MSG_INIT:
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_CLEAN:
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_DRAW:
      clip_save(&clip, gui_bitmap);
      set_clip(gui_bitmap, x1, y1, x2, y2);
      gui_draw_info = &draw_info;
      gui_box(x1, y1, x2, y2, 1, 1, GUI_EDGE_STYLE_IN);
      if (*me->flag) {
         line(gui_bitmap, x1 + 1, y1 + 1, x2 - 1, y2 - 1, 0x000000);
         line(gui_bitmap, x2 - 1, y1 + 1, x1 + 1, y2 - 1, 0x000000);
      }
      clip_load(&clip, gui_bitmap);
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_CLICK:
      if (point_in_rect(mouse_x, mouse_y, x1, y1, x2, y2)) {
         if (gui_mouse_ctrl == ctrl || gui_mouse_ctrl == NULL) {
            if (gui_mouse_ctrl == ctrl) {
               if (gui_mouse_info.action == GUI_MOUSE_ACTION_UP) {
                  *me->flag = !*me->flag;
               }
            }
            if (gui_mouse_info.action == GUI_MOUSE_ACTION_DOWN) {
               gui_mouse_ctrl = ctrl;
            }
         }
      }
      else {
         if (gui_mouse_info.action == GUI_MOUSE_ACTION_UP ||
             gui_mouse_info.action == GUI_MOUSE_ACTION_NONE) {
            if (gui_mouse_ctrl == ctrl) {
               gui_mouse_ctrl = NULL;
            }
         }
      }
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_KEY:
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_CHAR:
      ret = GUI_RET_NONE;
      break;
   }

   gui_parent_x = old_parent_x;
   gui_parent_y = old_parent_y;

   return ret;
}

/* Inserts new character c before the character at pos */
static int str_ins_char(char *str, int pos, char c)
{
   int len;

   len = strlen(str);

   if (pos < 0 || pos > len) {
      return 1;
   }

   memmove(&str[pos + 1], &str[pos], len - pos);
   str[pos] = c;

   return 0;
}

/* Deletes the character at pos */
static int str_del_char(char *str, int pos)
{
   int len;

   len = strlen(str);

   if (pos < 0 || pos >= len) {
      return 1;
   }

   memmove(&str[pos], &str[pos + 1], len - pos);

   return 0;
}

int gui_edit(struct gui_ctrl_t *ctrl, int msg, int mod)
{
   gui_edit_t *me;
   int x, y, w, h;
   int x1, y1, x2, y2;
   int old_parent_x, old_parent_y;
   int ret;
   int style;
   clip_t clip;
   char scan_code;
   char ascii_code;
   int len;
   int text_w, text_h;
   int text_x, text_y;
   int text_col;

   me = (gui_edit_t *)ctrl->data;

   old_parent_x = gui_parent_x;
   old_parent_y = gui_parent_y;

   x = me->x + gui_parent_x;
   y = me->y + gui_parent_y;
   w = me->w;
   h = me->h;

   gui_parent_x = x;
   gui_parent_y = y;

   x1 = x;
   y1 = y;
   x2 = x + w - 1;
   y2 = y + h - 1;

   ret = GUI_RET_NONE;

   switch (msg) {
   case GUI_MSG_INIT:
      if (me->cursor < 0) {
         me->cursor = strlen(me->text);
      }
      if ((me->buffer = malloc((me->length + 1) * sizeof(char))) == NULL) {
         exit(1);
      }
      me->buffer[0] = '\0';
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_CLEAN:
      free(me->buffer);
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_DRAW:
      clip_save(&clip, gui_bitmap);
      set_clip(gui_bitmap, x1, y1, x2, y2);
      gui_draw_info = &draw_info;
      gui_box(x1, y1, x2, y2, 1, 1, GUI_EDGE_STYLE_IN);

      text_w = text_length(font, me->text);
      text_h = text_height(font);

      align(x1, y1, x2, y2, text_w, text_h, GUI_CENTRE, GUI_MIDDLE, &text_x, &text_y);

      text_col = makecol_depth(bitmap_color_depth(gui_bitmap), gui_draw_info->field_text.r, gui_draw_info->field_text.g, gui_draw_info->field_text.b);

      text_mode(-1);
      textprintf(gui_bitmap, font, text_x, text_y, text_col, "%s", me->text);

      strncpy(me->buffer, me->text, me->cursor);
      me->buffer[me->cursor] = '\0';
      text_w = text_length(font, me->buffer);
      text_h = text_height(font);
      line(gui_bitmap, text_x + text_w, text_y, text_x + text_w, text_y + text_h, text_col);

      clip_load(&clip, gui_bitmap);
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_CLICK:
      if (point_in_rect(mouse_x, mouse_y, x1, y1, x2, y2)) {
         if (gui_mouse_ctrl == ctrl || gui_mouse_ctrl == NULL) {
            if (gui_mouse_ctrl == ctrl) {
               if (gui_mouse_info.action == GUI_MOUSE_ACTION_UP) {
               }
            }
            if (gui_mouse_info.action == GUI_MOUSE_ACTION_DOWN) {
               gui_mouse_ctrl = ctrl;
            }
         }
      }
      else {
         if (gui_mouse_info.action == GUI_MOUSE_ACTION_UP ||
             gui_mouse_info.action == GUI_MOUSE_ACTION_NONE) {
            if (gui_mouse_ctrl == ctrl) {
               gui_mouse_ctrl = NULL;
            }
         }
      }
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_CHAR:
      scan_code = mod >> 8;
      ascii_code = mod & 0xff;

      len = strlen(me->text);

      if (mod >> 8 == KEY_HOME) {
         me->cursor = 0;
      }
      else if (scan_code == KEY_END) {
         me->cursor = len;
      }
      else if (scan_code == KEY_LEFT) {
         me->cursor--;
      }
      else if (scan_code == KEY_RIGHT) {
         me->cursor++;
      }
      else if (scan_code == KEY_DEL) {
         if (me->cursor < len) {
            str_del_char(me->text, me->cursor);
            len--;
         }
      }
      else if (scan_code == KEY_BACKSPACE) {
         if (me->cursor > 0) {
            str_del_char(me->text, me->cursor - 1);
            len--;
            me->cursor--;
         }
      }
      else if (isprint(ascii_code)) {
         if (me->cursor < me->length) {
            str_ins_char(me->text, me->cursor, ascii_code);
            len++;
            me->cursor++;
         }
      }

      if (me->cursor < 0) me->cursor = 0;
      if (me->cursor > len) me->cursor = len;

      ret = GUI_RET_CHAR_USED;
      break;
   case GUI_MSG_KEY:
      ret = GUI_RET_NONE;
      break;
   }

   gui_parent_x = old_parent_x;
   gui_parent_y = old_parent_y;

   return ret;
}

int gui_window(struct gui_ctrl_t *ctrl, int msg, int mod)
{
   gui_window_t *me;
   int x, y, w, h;
   int x1, y1, x2, y2;
   int ret;
   int old_parent_x, old_parent_y;
   int mouse_ctrl_used = FALSE;

   me = (gui_window_t *)ctrl->data;

   old_parent_x = gui_parent_x;
   old_parent_y = gui_parent_y;

   x = me->x + gui_parent_x;
   y = me->y + gui_parent_y;
   w = me->w;
   h = me->h;

   gui_parent_x = x;
   gui_parent_y = y;

   x1 = x;
   y1 = y;
   x2 = x + w - 1;
   y2 = y + h - 1;

   ret = GUI_RET_NONE;

   switch (msg) {
   case GUI_MSG_INIT:
      ret = gui_msg(me->gui, GUI_MSG_INIT, mod);
      break;
   case GUI_MSG_CLEAN:
      ret = gui_msg(me->gui, GUI_MSG_CLEAN, mod);
      break;
   case GUI_MSG_DRAW:
      gui_draw_info = &draw_info;
      gui_box(x1, y1, x2, y2, 0, 0, GUI_EDGE_STYLE_OUT);
      ret = gui_msg(me->gui, GUI_MSG_DRAW, mod);
      break;
   case GUI_MSG_CLICK:
      if (gui_mouse_ctrl == ctrl) {
         mouse_ctrl_used = TRUE;
      }
      else {
         mouse_ctrl_used = FALSE;
      }

      if (mouse_ctrl_used) {
         gui_mouse_ctrl = NULL;
      }
      ret = gui_msg(me->gui, GUI_MSG_CLICK, mod);
      if (mouse_ctrl_used) {
         if (gui_mouse_ctrl == NULL) {
            gui_mouse_ctrl = ctrl;
         }
      }

      if (point_in_rect(me->old_mouse_x, me->old_mouse_y, x1, y1, x2, y2)) {
         if (gui_mouse_ctrl == ctrl || gui_mouse_ctrl == NULL) {
            if (gui_mouse_ctrl == ctrl) {
               if (gui_mouse_info.action == GUI_MOUSE_ACTION_HOLD) {
                  me->x += gui_mouse_info.x - me->old_mouse_x;
                  me->y += gui_mouse_info.y - me->old_mouse_y;
               }
            }
            if (gui_mouse_info.action == GUI_MOUSE_ACTION_DOWN) {
               gui_mouse_ctrl = ctrl;
            }
         }
      }
      else {
         if (gui_mouse_info.action == GUI_MOUSE_ACTION_UP ||
             gui_mouse_info.action == GUI_MOUSE_ACTION_NONE) {
            if (gui_mouse_ctrl == ctrl) {
               gui_mouse_ctrl = NULL;
            }
         }
      }
      me->old_mouse_x = gui_mouse_info.x;
      me->old_mouse_y = gui_mouse_info.y;
      ret = GUI_RET_NONE;
      break;
   case GUI_MSG_KEY:
      ret = gui_msg(me->gui, GUI_MSG_KEY, mod);
      break;
   case GUI_MSG_CHAR:
      ret = gui_msg(me->gui, GUI_MSG_CHAR, mod);
      break;
   default:
      ret = GUI_RET_NONE;
      break;
   }

   gui_parent_x = old_parent_x;
   gui_parent_y = old_parent_y;

   return ret;
}

