#include "display.h"

void display_init(display_t *display)
{
   display->in_w = display->in_h = display->out_w = display->out_h = 0;
   display->in_depth = display->out_depth = 0;
   display->buffer = NULL;
}

void display_update(display_t *display)
{
   acquire_screen();
   if (display->in_w == display->out_w && display->in_h == display->out_h) {
      blit(display->buffer, screen, 0, 0, 0, 0, display->out_w, display->out_h);
   }
   else {
      stretch_blit(display->buffer, screen, 0, 0, display->in_w, display->in_h, 0, 0, display->out_w, display->out_h);
   }
   release_screen();
}

void display_set_out(display_t *display, int card, int w, int h, int depth)
{
   display->card = card;
   display->out_w = w;
   display->out_h = h;
   display->out_depth = depth;
}

int display_set(display_t *display)
{
   set_color_depth(display->out_depth);
   return set_gfx_mode(display->card, display->out_w, display->out_h, 0, 0);
}

void display_set_in(display_t *display, int w, int h, int depth)
{
   display->in_w = w;
   display->in_h = h;
   display->in_depth = depth;
}

int display_create_buffer(display_t *display)
{
   if ((display->buffer = create_bitmap_ex(display->in_depth, display->in_w, display->in_h)) == NULL) {
      return 1;
   }

   return 0;
}

void display_destroy_buffer(display_t *display)
{
   if (display->buffer != NULL) {
      destroy_bitmap(display->buffer);
      display->buffer = NULL;
   }
}

void display_clean(display_t *display)
{
   display_destroy_buffer(display);
}
