#ifndef _ASTAR_H
#define _ASTAR_H

#include "pqueue.h"
#include "list.h"
#include "path.h"

typedef struct _astar_node_t {
   int f; /* Goodness g + h */
   int g; /* Cost to get here from start */
   int h; /* Hypothetical cost to get to finish */
   int x, y; /* Map position */
   void *parent;
   int successor_count;
   void *successors[8];
} _astar_node_t;

void _astar_node_init(_astar_node_t *node);

typedef struct astar_t {
   void *data; /* Map information */
   pqueue_t *open; /* Open priority queue */
   list_t *closed; /* Closed node list */
   int (*cost)(int s_x, int s_y, int f_x, int f_y, void *data); /* The cost function */
   int (*valid)(int x, int y, void *data); /* The validity function */
   int (*estimate)(int s_x, int s_y, int f_x, int f_y, void *data); /* The distance estimating function */
} astar_t;

void astar_init(astar_t *astar);
int astar_search(astar_t *astar, int s_x, int s_y, int f_x, int f_y, path_t *path);

#endif
