#include "astar.h"

#include <stdlib.h>
#include <allegro.h>

#include "path.h"

void _astar_node_init(_astar_node_t *node)
{
   int i;

   node->x = 0;
   node->y = 0;
   node->successor_count = 0;
   node->parent = NULL;
   for (i = 0; i < 8; i++) {
      node->successors[i] = NULL;
   }
}

void astar_init(astar_t *astar)
{
   astar->open = NULL;
   astar->closed = NULL;
}

int astar_search(astar_t *astar, int s_x, int s_y, int f_x, int f_y, path_t *path)
{
   _astar_node_t *start = NULL;
   _astar_node_t *node = NULL;
   _astar_node_t *successor = NULL;
   _astar_node_t *cur = NULL;
   _astar_node_t *end = NULL;
   pqueue_t *open_cur;
   list_t *closed_cur;
   list_t *temp;
   int i, j;
   int in_open, in_closed;
   int new_g;
   int successor_index;
   int successor_x, successor_y;
   int path_size;
   int path_pos;

   start = (_astar_node_t *)malloc(sizeof(_astar_node_t));
   _astar_node_init(start);

   start->x = s_x;
   start->y = s_y;
   start->g = 0;
   start->h = astar->estimate(start->x, start->y, f_x, f_y, astar->data);
   start->f = start->g + start->h;
   start->parent = NULL;

   pqueue_push_data(&astar->open, start, start->f);

   while (astar->open) {
      node = NULL;
      node = pqueue_pop_data(&astar->open);
      if (node->x == f_x && node->y == f_y) {
         /* Build the path */
         path_init(path);
         path_size = 0;
         cur = node;
         while (cur) {
            path_size++;
            cur = cur->parent;
         }
         path->size = path_size;
         path_create_steps(path);
         path_pos = 0;
         end = NULL;
         while (end != node) {
            cur = node;
            while (cur->parent != end) {
               cur = cur->parent;
            }
            end = cur;
            path->steps[path_pos].x = cur->x;
            path->steps[path_pos].y = cur->y;
            path_pos++;
         }

         while (astar->open) {
            free(pqueue_pop_data(&astar->open));
         }

         closed_cur = astar->closed;
         while (closed_cur) {
            temp = closed_cur;
            closed_cur = closed_cur->next;
            free(list_pop_data(&astar->closed, temp->data));
         }

         return 0;
      }
      successor_index = 0;
      for (i = -1; i < 2; i++) {
         for (j = -1; j < 2; j++) {
            if (i == 0 && j == 0) {
               continue;
            }

            if (!astar->valid(node->x + i, node->y + j, astar->data)) {
               successor_index++;
               continue;
            }

            successor_x = node->x + i;
            successor_y = node->y + j;

            new_g = node->g + astar->cost(node->x, node->y, successor_x, successor_y, astar->data);

            in_open = 0;
            open_cur = astar->open;
            while (open_cur) {
               if (((_astar_node_t *)open_cur->data)->x == successor_x &&
                   ((_astar_node_t *)open_cur->data)->y == successor_y) {
                  successor = (_astar_node_t *)open_cur->data;
                  in_open = 1;
                  break;
               }
               open_cur = open_cur->next;
            }

            in_closed = 0;
            closed_cur = astar->closed;
            while (closed_cur) {
               if (((_astar_node_t *)closed_cur->data)->x == successor_x &&
                   ((_astar_node_t *)closed_cur->data)->y == successor_y) {
                  successor = (_astar_node_t *)closed_cur->data;
                  in_closed = 1;
                  break;
               }
               closed_cur = closed_cur->next;
            }

            if ((in_open || in_closed) && successor->g <= new_g) {
               continue;
            }

            if (!in_open && !in_closed) {
               node->successors[successor_index] = (_astar_node_t *)malloc(sizeof(_astar_node_t));
               successor = (_astar_node_t *)(node->successors[successor_index]);
               _astar_node_init(successor);
            }
            successor_index++;

            successor->x = successor_x;
            successor->y = successor_y;
            successor->parent = node;
            successor->g = new_g;
            successor->h = astar->estimate(successor->x, successor->y, f_x, f_y, astar->data);
            successor->f = successor->g + successor->h;
            if (in_closed) {
               list_pop_data(&astar->closed, successor);
            }
            if (!in_open) {
               pqueue_push_data(&astar->open, successor, successor->f);
            }
         }
      }
      list_push_data(&astar->closed, node, astar->closed);
   }

   while (astar->open) {
      free(pqueue_pop_data(&astar->open));
   }

   closed_cur = astar->closed;
   while (closed_cur) {
      temp = closed_cur;
      closed_cur = closed_cur->next;
      free(list_pop_data(&astar->closed, temp->data));
   }

   return 1;
}

