#ifndef _ARMY_H
#define _ARMY_H

#include <stdio.h>

#include "list.h"
#include "view.h"
#include "unit.h"
#include "path.h"

#define ARMY_UNIT_SIZE 8

typedef struct army_t {
   int size;
   int side;
   int x, y;
   int start_x, start_y;
   int target_x, target_y;
   float sub_pos;
   unit_t *units[ARMY_UNIT_SIZE];
   int selected[ARMY_UNIT_SIZE];
   path_t path;
} army_t;

typedef void (army_drawer_t)(const army_t *army, const view_t *view, float x, float y);

army_drawer_t army_draw;
army_drawer_t mini_army_draw;

/* Initialise */
void army_init(army_t *army);

/* Draw */
army_drawer_t army_draw;
army_drawer_t mini_army_draw;

/* Create/destroy */
army_t *army_create(void);
void army_destroy(army_t **army);

/* File I/O */
int army_read(army_t *army, FILE *file);
int army_write(army_t *army, FILE *file);
int army_list_reader(void *army, FILE *file);
int army_list_writer(void *army, FILE *file);
int army_list_read(list_t **list, FILE *file);
int army_list_write(list_t **list, FILE *file);

/* Merge/split */
int army_merge(army_t *army, army_t *merger);
int army_merge_selected(army_t *army, army_t *merger, int *selected);
int army_split(army_t *army, army_t *spliter, int *selected);

/* Push/pop */
army_t *army_list_push(list_t **list, army_t *army);
army_t *army_list_pop(list_t **list, army_t *army);

/* Clean */
void army_list_clean(list_t **list);
void army_list_cleaner(void *army);

#endif
