#include "view.h"

void view_to_unit(const view_t *view, float view_x, float view_y, float *unit_x, float *unit_y)
{
   *unit_x = (view_x - view->offset_x) / view->unit_w_pixels + view->focus_x;
   *unit_y = (view_y - view->offset_y) / view->unit_h_pixels + view->focus_y;
}

void unit_to_view(const view_t *view, float unit_x, float unit_y, float *view_x, float *view_y)
{
   *view_x = (unit_x - view->focus_x) * view->unit_w_pixels + view->offset_x;
   *view_y = (unit_y - view->focus_y) * view->unit_h_pixels + view->offset_y;
}

void view_to_screen(const view_t *view, float view_x, float view_y, float *screen_x, float *screen_y)
{
   *screen_x = view_x + view->x;
   *screen_y = view_y + view->y;
}

void screen_to_view(const view_t *view, float screen_x, float screen_y, float *view_x, float *view_y)
{
   *view_x = screen_x - view->x;
   *view_y = screen_y - view->y;
}

void view_init(view_t *view)
{
   view->x = view->y = 0;
   view->w = view->h = 0;
   view->offset_x = view->offset_y = 0;
   view->focus_x = view->focus_y = 0.0;
   view->unit_w_pixels = view->unit_h_pixels = 1.0;
   view->draw = NULL;
   view->dest = NULL;
}

void view_set(view_t *view, BITMAP *dest, int x, int y, int w, int h, int offset_x, int offset_y)
{
   view->dest = dest;
   view->x = x;
   view->y = y;
   view->w = w;
   view->h = h;
   view->offset_x = offset_x;
   view->offset_y = offset_y;
}

int view_create_draw(view_t *view)
{
   if ((view->draw = create_sub_bitmap(view->dest, view->x, view->y, view->w, view->h)) == NULL) {
      return 1;
   }

   return 0;
}

void view_destroy_draw(view_t *view)
{
   if (view->draw != NULL) {
      destroy_bitmap(view->draw);
      view->draw = NULL;
   }
}

void view_clean(view_t *view)
{
   view_destroy_draw(view);
}

