#ifndef _TERRAIN_H
#define _TERRAIN_H

#include <allegro.h>

#define TERRAIN_TYPE_COUNT 16
#define TERRAIN_TYPE_NAME_SIZE 32
#define TERRAIN_TYPE_DESC_SIZE 256

typedef struct terrain_type_t {
   char name[TERRAIN_TYPE_NAME_SIZE];
   char desc[TERRAIN_TYPE_DESC_SIZE];
   int move_cost_straight;
   int move_cost_diagonal;
   // Adjusts by rate
   int attack_modifier;
   int defend_modifier;
   int sight_modifier;
   // Display
//   int colour;
   RGB colour;
   int tile;
   // attribs
   int steepness; /* How steep the hill */
   int roughness; /* How rough the rubble */
   int denseness; /* How thick the forest */
   int highness; /* How high the mountain */
   int deepness; /* How deep the water */
} terrain_type_t;

extern terrain_type_t terrain_types[];

typedef struct terrain_t {
   int type;
   int tile;
} terrain_t;

void terrain_init(terrain_t *terrain);

#endif
