#ifndef _PROGRAM_H
#define _PROGRAM_H

#include "display.h"

#include "map.h"
#include "path.h"
#include "list.h"
#include "army.h"
#include "unit.h"
#include "view.h"
#include "astar.h"

typedef struct {
   display_t display;
   int state;
} program_t;

void program_init(program_t *program);
int program_startup(program_t *program);
int program_run(program_t *program);
void program_shutdown(program_t *program);
void program_clean(program_t *program);

#endif
