#include "pqueue.h"

#include <stdlib.h>

pqueue_t *pqueue_push(pqueue_t **queue, pqueue_t *node)
{
   pqueue_t *pos;
   pqueue_t *prev;

   if (*queue) {
      prev = NULL;
      pos = *queue;
      while (pos && node->priority > pos->priority) {
         prev = pos;
         pos = pos->next;
      }
      node->next = pos;
      if (prev) {
         prev->next = node;
      }
      if (pos == *queue) {
         *queue = node;
      }
   }
   else {
      *queue = node;
   }
   return node;
}

pqueue_t *pqueue_pop(pqueue_t **queue)
{
   pqueue_t *node;

   node = *queue;
   *queue = (*queue)->next;
   node->next = NULL;

   return node;
}

void *pqueue_push_data(pqueue_t **queue, void *data, int priority)
{
   pqueue_t *node;

   if ((node = (pqueue_t *)malloc(sizeof(pqueue_t))) == NULL) {
      return NULL;
   }
   node->data = data;
   node->next = NULL;
   node->priority = priority;
   pqueue_push(queue, node);

   return data;
}

void *pqueue_pop_data(pqueue_t **queue)
{
   pqueue_t *node;
   void *data;

   node = pqueue_pop(queue);
   data = node->data;
   free(node);

   return data;
}

