#include "path.h"

#include <stdlib.h>
#include <stdio.h>

void path_step_init(path_step_t *step)
{
   step->x = -1;
   step->y = -1;
}

int path_step_read(path_step_t *step, FILE *file)
{
   if (fread((void *)step, sizeof(path_step_t), 1, file) < 1) {
      return 1;
   }

   return 0;
}

int path_step_write(path_step_t *step, FILE *file)
{
   if (fwrite((void *)step, sizeof(path_step_t), 1, file) < 1) {
      return 1;
   }

   return 0;
}

void path_init(path_t *path)
{
   path->size = 0;
   path->pos = 0;
   path->steps = NULL;
}

int path_create_steps(path_t *path)
{
   int i;

   if (path->size > 0) {
      if ((path->steps = malloc(sizeof(path_step_t) * path->size)) == NULL) {
         return 1;
      }
      for (i = 0; i < path->size; i++) {
         path_step_init(&path->steps[i]);
      }
   }
   else {
      path->steps = NULL;
   }

   return 0;
}

void path_destroy_steps(path_t *path)
{
   if (path->steps != NULL) {
      free(path->steps);
      path->steps = NULL;
   }
}

void path_clean(path_t *path)
{
   path_destroy_steps(path);
}

int path_read(path_t *path, FILE *file)
{
   int i;

   if (fread((void *)&path->size, sizeof(int), 1, file) < 1) {
      return 1;
   }
   if (fread((void *)&path->pos, sizeof(int), 1, file) < 1) {
      return 1;
   }

   if (path_create_steps(path)) {
      return 1;
   }

   for (i = 0; i < path->size; i++) {
      if (fread((void *)&path->steps[i], sizeof(int), 1, file) < 1) {
         return 1;
      }
   }

   return 0;
}

int path_write(path_t *path, FILE *file)
{
   int i;

   if (fwrite((void *)&path->size, sizeof(int), 1, file) < 1) {
      return 1;
   }
   if (fwrite((void *)&path->pos, sizeof(int), 1, file) < 1) {
      return 1;
   }

   for (i = 0; i < path->size; i++) {
      if (fwrite((void *)&path->steps[i], sizeof(int), 1, file) < 1) {
         return 1;
      }
   }

   return 0;
}

