#ifndef _MAP_H
#define _MAP_H

#include <stdio.h>

#define SQUARE_UNIT_COUNT 8

#define MAP_NAME_SIZE 32
#define MAP_DESC_SIZE 256

#define MAP_SIDE_COUNT 8

#include "army.h"
#include "unit.h"
#include "side.h"
#include "view.h"
#include "terrain.h"
#include "structure.h"

typedef struct square_t {
   terrain_t terrain;
} square_t;

typedef void (square_drawer_t)(const square_t *square, const view_t *view, float x, float y);

void square_init(square_t *square);
int square_write(square_t *square, FILE *file);
int square_read(square_t *square, FILE *file);
square_drawer_t square_draw;
square_drawer_t mini_square_draw;

typedef struct map_t {
   char name[MAP_NAME_SIZE];
   char desc[MAP_DESC_SIZE];
   int w, h;
   int turn;
   int side_count;
   int side_turn;
   int side_order[MAP_SIDE_COUNT];
   square_t **squares;
   list_t *units;
   list_t *structures;
   list_t *armies;
} map_t;

int map_write(map_t *map, FILE *file);
int map_read(map_t *map, FILE *file);
int map_create_squares(map_t *map);
void map_destroy_squares(map_t *map);
void map_init(map_t *map);
map_t *map_load(const char *filename);
int map_save(map_t *map, const char *filename);
map_t *map_create(void);
void map_destroy(map_t *map);
void map_clean(map_t *map);
void map_draw(map_t *map, const view_t *view, square_drawer_t *square_drawer, army_drawer_t *army_drawer);
void mini_map_draw(map_t *map, const view_t *view);

extern map_t *current_map;

int map_generate(map_t *map);

typedef struct {
  int x, y;
  int power;
} seed_t;

#endif
