#ifndef _HMAP_POSTPROC_H
#define _HMAP_POSTPROC_H

#include "hmap.h"

void hmap_gaussian_blur(hmap_t *in, hmap_t *out, double dist, int contain);
void hmap_soften(hmap_t *in, hmap_t *out, int contain);

void hmap_get_range(hmap_t *hmap, double *min, double *max);
void hmap_set_range(hmap_t *hmap, double min, double max);
void hmap_invert(hmap_t *hmap);
void hmap_high_pass(hmap_t *hmap, double val);
void hmap_low_pass(hmap_t *hmap, double val);
void hmap_scale(hmap_t *hmap, double val);
void hmap_shift(hmap_t *hmap, double val);
void hmap_normalize(hmap_t *hmap);
void hmap_clear(hmap_t *hmap);
void hmap_copy(hmap_t *in, hmap_t *out);

void hmap_multiply(hmap_t *a, hmap_t *b, hmap_t *out);
void hmap_divide(hmap_t *a, hmap_t *b, hmap_t *out);
void hmap_add(hmap_t *a, hmap_t *b, hmap_t *out);
void hmap_subtract(hmap_t *a, hmap_t *b, hmap_t *out);

typedef double (hmap_unary_t)(double a);
typedef double (hmap_binary_t)(double a, double b);
typedef double (hmap_ternary_t)(double a, double b, double c);

hmap_unary_t hmap_inverse;
hmap_binary_t hmap_max;
hmap_binary_t hmap_min;
hmap_ternary_t hmap_mid;

void hmap_unary(hmap_t *a, hmap_t *out, hmap_unary_t *method);
void hmap_binary(hmap_t *a, hmap_t *b, hmap_t *out, hmap_binary_t *method);
void hmap_ternary(hmap_t *a, hmap_t *b, hmap_t *c, hmap_t *out, hmap_ternary_t *method);

#endif
