#include "interp.h"

#include <math.h>
#include <stdio.h>

short shortlerp(short a, short b, short pos)
{
   return a + (b - a) * pos / 65536;
}

char charlerp(char a, char b, char pos)
{
   return a + (b - a) * pos / 255;
}

double linear_interp(double *samp, double pos)
{
   return samp[0] + (samp[1] - samp[0]) * pos;
}

double cosine_interp(double *samp, double pos)
{
   double ft, f;

   ft = pos * M_PI;
   f = (1 - cos(ft)) * 0.5;
   return samp[0] + (samp[1] - samp[0]) * f;
}

double cubic_interp(double *samp, double pos)
{
   double p, q, r, s;

   p = (samp[3] - samp[2]) - (samp[0] - samp[1]);
   q = (samp[0] - samp[1]) - p;
   r = samp[2] - samp[0];
   s = samp[1];

   return p * pow(pos, 3) + q * pow(pos, 2) + r * pos + s;
}

double bilinear_interp(double *samp, double *pos)
{
   double buf[4];

   return poly_interp(linear_interp, 2, 2, samp, pos, buf);
}

double bicosine_interp(double *samp, double *pos)
{
   double buf[4];

   return poly_interp(cosine_interp, 2, 2, samp, pos, buf);
}

double bicubic_interp(double *samp, double *pos)
{
   double buf[16];

   return poly_interp(cubic_interp, 2, 4, samp, pos, buf);
}

int int_pow(int x, int y)
{
   int p;
   int i;

   p = x;
   for (i = 1; i < y; i++) {
      p *= x;
   }

   return p;
}

double poly_interp(double (*method)(double *samp, double pos), unsigned int dim, int interp_samps, double *samp, double *pos, double *buf)
{
   int i, j;
   int samp_count;
   double *array = NULL;

   samp_count = int_pow(interp_samps, dim);

   if (buf == NULL) {
      array = samp;
   }
   else {
      for (i = 0; i < samp_count; i++) {
         buf[i] = samp[i];
      }
      array = buf;
   }

   for (i = dim; i >= 1; i--) {
      samp_count = int_pow(interp_samps, i);
      for (j = 0; j < samp_count; j += interp_samps) {
         array[j / interp_samps] = method(&(array[j]), pos[dim - i]);
      }
   }

   return array[0];
}
