#include <stdlib.h>
#include <allegro.h>
#include <math.h>
#include <time.h>

#include "perlin.h"
#include "interp.h"
#include "hmap.h"
#include "generate.h"
#include "postproc.h"
#include "colmap.h"
#include "math.h"

int main(void)
{
   int i, j;
   hmap_t hmap, out;
   double persistence;
   int octaves;
   double colour_pos;
   int r, g, b;
   double col_buf[12];
   colmap_t colour_map[] = {
    {  0.0000,   0,   0,  63 },
    {  0.0625,   0,   0,  95 },
    {  0.1250,   0,   0, 127 },
    {  0.3750,   0,   0, 191 },
    {  0.4865,   0,  95, 255 },
    {  0.5000, 159, 159,  63 },
    {  0.6000,   0,  95,   0 },
    {  0.7000,  63,  95,  15 },
    {  0.7500,  87,  79,  63 },
    {  0.8000,  95,  95,  95 },
    {  1.0000, 191, 191, 191 },
    { -1.0000,   0,   0,   0 }
   };
/*   colmap_t colour_map[] = {
    {  0.0000, 255,   0,   0 },
    {  1.0000,   0,   0, 255 },
    { -1.0000,   0,   0,   0 }
   };*/
/*   colmap_t colour_map[] = {
    {  0.0000,   0,   0,   0 },
    {  1.0000, 255, 255, 255 },
    { -1.0000,   0,   0,   0 }
   };*/
/*   colmap_t colour_map[] = {
    {  0.0000, 255, 191, 191 },
    {  0.2125, 255, 255, 255 },
    {  0.2500,   0,   0,   0 },
    {  0.2875, 255, 255, 255 },
    {  0.3750, 191, 255, 191 },
    {  0.4625, 255, 255, 255 },
    {  0.5000,   0,   0,   0 },
    {  0.5375, 255, 255, 255 },
    {  0.6250, 255, 255, 191 },
    {  0.7125, 255, 255, 255 },
    {  0.7500,   0,   0,   0 },
    {  0.7875, 255, 255, 255 },
    {  1.0000, 191, 191, 255 },
    { -1.0000,   0,   0,   0 }
   };*/
   double off_x, off_y;

   hmap_init(&hmap);
   hmap.w = 256;
   hmap.h = 256;
   hmap_create_squares(&hmap);

   hmap_init(&out);

   allegro_init();

   set_color_depth(24);
   set_gfx_mode(GFX_AUTODETECT, 400, 300, 0, 0);

   clear(screen);

   install_keyboard();
   install_mouse();

   persistence = 1.0 / pow(2.0, 1.0 / 2.0);
   octaves = 8;

   while (!key[KEY_ESC] && !(mouse_b)) {

      hmap_clear(&hmap);

      off_x = rand() % 65536;
      off_y = rand() % 65536;

      textprintf(screen, font, 0, 0, 0xffffff, "Generating...");

//      hmap_perlin(&hmap, persistence, octaves);
//      hmap_frequency_composition(&hmap, 64);
//      hmap_circles(&hmap, 10000, 24);
//      hmap_faulting(&hmap, 1024, 1);
//      hmap_fault(&hmap, 1024, 1);
//      hmap_collage(&hmap, point_collager, 1000000, 1, CONTAIN_WRAP);
//      hmap_collage_reduce(&hmap, square_collager, 10000, 64, CONTAIN_WRAP);
//      hmap_collage(&hmap, circle_collager, 2000, 32, CONTAIN_WRAP);
//      hmap_collage(&hmap, bump_collager, 1000, 8, CONTAIN_WRAP);
//      hmap_collage_reduce(&hmap, cone_collager, 1000, 64, CONTAIN_WRAP);
//      hmap_collage_reduce(&hmap, bump_collager, 1000, 64, CONTAIN_WRAP);
//      hmap_collage_reduce(&hmap, crater_collager, 1000, 64, CONTAIN_WRAP);
//      hmap_collage_reduce(&hmap, circle_collager, 1000, 64, CONTAIN_WRAP);
//      hmap_collage_reduce(&hmap, fault_collager, 1000, 64, CONTAIN_WRAP);
//      hmap_collage_reduce(&hmap, pyramid_collager, 1000, 64, CONTAIN_WRAP);
//      hmap_collage_reduce(&hmap, diamond_collager, 1000, 64, CONTAIN_WRAP);
//      hmap_collage_reduce(&hmap, hemisphere_collager, 100, 64, CONTAIN_WRAP);
//      hmap_collage_reduce(&hmap, inverse_hemisphere_collager, 1000, 64, CONTAIN_WRAP);
//      hmap_collage_reduce(&hmap, peak_collager, 1000, 64, CONTAIN_WRAP);
//      hmap_collage(&hmap, square_collager, 1000, 64, CONTAIN_WRAP);
//      hmap_fault2(&hmap, 512, 1);
//      hmap_subdivision(&hmap, 256, 8);
//      hmap_collage_rect(&hmap, 10000, 16);
//      hmap_deposition2(&hmap, peak_collager, 64, 64, 8, 8, CONTAIN_WRAP);
      hmap_deposition2(&hmap, inverse_hemisphere_collager, 32, 32, 32, 32, CONTAIN_WRAP);
//      hmap_deposition2(&hmap, peak_collager, 256, 256, 4, 4, CONTAIN_WRAP);
//      hmap_deposition3(&hmap, peak_collager, 64, 64, 8, 8, CONTAIN_WRAP);
//      hmap_deposition3(&hmap, point_collager, 128, 65536, 1, 1, CONTAIN_WRAP);
//      hmap_deposition4(&hmap, diamond_collager, 64, 64, 32, 32, CONTAIN_WRAP);
//      hmap_deposition2(&hmap, point_collager, 8, 32, 4, 4, CONTAIN_WRAP);
//      hmap_deposition2(&hmap, circle_collager, 32, 32, 32, 32, CONTAIN_WRAP);

      textprintf(screen, font, 0, 0, 0xffffff, "Post Proccessing...");

      hmap_normalize(&hmap);
      hmap_shift(&hmap, 1.0);
      hmap_scale(&hmap, 0.5);

//      hmap_soften(&hmap, &out);
//      hmap_gaussian_blur(&hmap, &out, 8.0, CONTAIN_WRAP);
//      hmap_gaussian_blur(&hmap, &out, 1.0, CONTAIN_WRAP);
//      hmap_gaussian_blur(&hmap, NULL, 4.0, CONTAIN_WRAP);
//      hmap_soften(&hmap, NULL, CONTAIN_WRAP);
      hmap_copy(&hmap, &out);

      for (i = 0; i < out.w; i++) {
         for (j = 0; j < out.h; j++) {
            colour_pos = out.squares[i][j];
            colmap_get(colour_map, linear_interp, 2, 0, colour_pos, &r, &g, &b, col_buf);
//            colmap_get(colour_map, cosine_interp, 2, 0, colour_pos, &r, &g, &b, col_buf);
//            colmap_get(colour_map, cubic_interp, 4, -1, colour_pos, &r, &g, &b, col_buf);
            putpixel(screen, i, j, makecol24(r, g, b));
         }
      }

      clear_keybuf();

      while (!keypressed() && !mouse_b);
   }

   hmap_clean(&hmap);
   hmap_clean(&out);

   return EXIT_SUCCESS;
}
END_OF_MAIN();
