#include "utility.h"

#include <allegro.h>

#include "math.h"

int point_in_rect(int point_x, int point_y, int x1, int y1, int x2, int y2)
{
   if (point_x < x1 || point_x > x2 ||
       point_y < y1 || point_y > y2) {
      return 0;
   }

   return 1;
}

int point_in_circle(int point_x, int point_y, int x, int y, int r)
{
   if (dist(point_x, point_y, x, y) > r) {
      return 0;
   }

   return 1;
}

int clip_load(clip_t *clip, BITMAP *bitmap)
{
   if (bitmap == NULL) return 1;

   bitmap->ct = clip->top;
   bitmap->cb = clip->bottom;
   bitmap->cl = clip->left;
   bitmap->cr = clip->right;

   return 0;
}

int clip_save(clip_t *clip, BITMAP *bitmap)
{
   if (bitmap == NULL) return 1;

   clip->top = bitmap->ct;
   clip->bottom = bitmap->cb;
   clip->left = bitmap->cl;
   clip->right = bitmap->cr;

   return 0;
}

