#ifndef _GUI_H
#define _GUI_H

#include <allegro.h>

#define GUI_MSG_INIT    1
#define GUI_MSG_CLEAN   2
#define GUI_MSG_DRAW    3
#define GUI_MSG_CLICK   4
#define GUI_MSG_KEY     5
#define GUI_MSG_CHAR    6

/* Static flags */
#define GUI_FLG_STA_SELECTED  1
#define GUI_FLG_STA_FOCUS     2
#define GUI_FLG_STA_VISIBLE   8
#define GUI_FLG_STA_ENABLED  16

#define GUI_RET_NONE          1
#define GUI_RET_MOUSE_USED    2
#define GUI_RET_CLICK_USED    3
#define GUI_RET_KEY_USED      4
#define GUI_RET_CHAR_USED     5

#define GUI_MOUSE_ACTION_NONE 0
#define GUI_MOUSE_ACTION_HOLD 1
#define GUI_MOUSE_ACTION_UP   2
#define GUI_MOUSE_ACTION_DOWN 3

typedef struct gui_mouse_button_info_t {
   int click_wait;
   int action;
} gui_mouse_button_info_t;

typedef struct gui_mouse_info_t {
   int click_wait;
   int action;
   int x, y;
} gui_mouse_info_t;

void update_mouse_action(gui_mouse_info_t *mouse_info, int click, int x, int y);

typedef struct gui_ctrl_t {
   int (*func)(struct gui_ctrl_t *ctrl, int msg, int mod);
   void *data;
//   int flags_static;
//   int flags_volatile;
} gui_ctrl_t;

typedef struct gui_group_t {
   gui_ctrl_t *mouse_ctrl;
   gui_ctrl_t *focus_ctrl;
   /* Controls */
   gui_ctrl_t *ctrls;
//   int ctrls_type; /* List or array */
//   void *ctrls;
} gui_group_t;

typedef struct gui_t {
   gui_group_t *group;
   /* Drawing */
   BITMAP *gui_bitmap;
   int draw_type; /* Direct screen redraw or buffered */
   gui_mouse_info_t mouse_info;
} gui_t;

extern BITMAP *gui_bitmap;
extern int gui_parent_x;
extern int gui_parent_y;
extern gui_mouse_info_t gui_mouse_info;

int gui_ctrl_msg(gui_ctrl_t *ctrl, int msg, int mod);
int gui_msg(gui_ctrl_t *gui, int msg, int mod);

int gui_init(gui_ctrl_t *gui);
int gui_update(gui_ctrl_t *gui);
int gui_draw(gui_ctrl_t *gui);
void gui_clean(gui_ctrl_t *gui);

int gui_play(gui_ctrl_t *gui);

extern int gui_parent_x;
extern int gui_parent_y;
extern int gui_parent_w;
extern int gui_parent_h;

extern gui_ctrl_t *gui_mouse_ctrl;
extern gui_ctrl_t *gui_focus_ctrl;

#endif
