#include "gui.h"

#include "math.h"

BITMAP *gui_bitmap = NULL;
gui_mouse_info_t gui_mouse_info;

void update_mouse_action(gui_mouse_info_t *mouse_info, int click, int x, int y)
{
   mouse_info->x = x;
   mouse_info->y = y;

   if (click) {
      switch (mouse_info->action) {
      case GUI_MOUSE_ACTION_NONE:
      case GUI_MOUSE_ACTION_UP:
         mouse_info->action = GUI_MOUSE_ACTION_DOWN;
         break;
      case GUI_MOUSE_ACTION_DOWN:
      case GUI_MOUSE_ACTION_HOLD:
         mouse_info->action = GUI_MOUSE_ACTION_HOLD;
         break;
      default:
         mouse_info->action = GUI_MOUSE_ACTION_DOWN;
         break;
      }
   }
   else {
      switch (mouse_info->action) {
      case GUI_MOUSE_ACTION_NONE:
      case GUI_MOUSE_ACTION_UP:
         mouse_info->action = GUI_MOUSE_ACTION_NONE;
         break;
      case GUI_MOUSE_ACTION_DOWN:
      case GUI_MOUSE_ACTION_HOLD:
         mouse_info->action = GUI_MOUSE_ACTION_UP;
         break;
      default:
         mouse_info->action = GUI_MOUSE_ACTION_NONE;
         break;
      }
   }
}

int gui_parent_x = 0;
int gui_parent_y = 0;
int gui_parent_w = 0;
int gui_parent_h = 0;

gui_ctrl_t *gui_mouse_ctrl = NULL;
gui_ctrl_t *gui_focus_ctrl = NULL;

int gui_ctrl_msg(gui_ctrl_t *ctrl, int msg, int mod)
{
   int ret;

   ret = ctrl->func(ctrl, msg, mod);

   return ret;
}

int gui_msg(gui_ctrl_t *gui, int msg, int mod)
{
   int i;
   int ret;

   ret = GUI_RET_NONE;
   for (i = 0; gui[i].func != NULL; i++) {
      ret = gui_ctrl_msg(&gui[i], msg, mod);
      if (ret != GUI_RET_NONE) {
         break;
      }
   }

   return ret;
}

int gui_init(gui_ctrl_t *gui)
{
   gui_msg(gui, GUI_MSG_INIT, 0);

   return 0;
}

int gui_update(gui_ctrl_t *gui)
{
   int k;
   int ret;

   update_mouse_action(&gui_mouse_info, mouse_b & 1, mouse_x, mouse_y);
   gui_msg(gui, GUI_MSG_CLICK, 0);
   while (keypressed()) {
      k = readkey();
      if ((k >> 8) == KEY_TAB) {
         if (key_shifts & KB_SHIFT_FLAG) {
         }
         else {
         }
      }
      gui_msg(gui, GUI_MSG_KEY, k);
      ret = gui_msg(gui, GUI_MSG_CHAR, k);
      if (ret != GUI_RET_CHAR_USED) {
         simulate_keypress(k);
      }
   }

   return 0;
}

int gui_draw(gui_ctrl_t *gui)
{
   gui_msg(gui, GUI_MSG_DRAW, 0);

   return 0;
}

void gui_clean(gui_ctrl_t *gui)
{
   gui_msg(gui, GUI_MSG_CLEAN, 0);
}

int gui_play(gui_ctrl_t *gui)
{
   int end;

   end = 0;

   gui_init(gui);

   while (!end) {
      end = gui_update(gui);
      gui_draw(gui);
   }

   gui_clean(gui);

   return end;
}
