/*
 * Lords of War
 * By Carl Olsson
 * March 2001
 */

#include <stdlib.h>
#include <allegro.h>
#include <math.h>
#include <time.h>

#include "gui.h"
#include "gui_ctrl.h"

int video_w = 640;
int video_h = 480;
int video_depth = 24;

BITMAP *screen_buffer = NULL;

int exit_flag = FALSE;

volatile int speed;

void speed_regulator(void)
{
   speed++;
}
END_OF_FUNCTION(speed_regulator);

volatile int frame;
volatile int fps;
volatile int cycle;
volatile int cps;

void persecond(void)
{
   fps = frame;
   frame = 0;
   
   cps = cycle;
   cycle = 0;
}
END_OF_FUNCTION(persecond);

gui_menu_item_t menu1[] = {
 { "ting", NULL, menu1 },
 { "ting 2", NULL, NULL },
 { NULL, NULL, NULL },
};

gui_menu_item_t menu2[] = {
 { "thing", NULL, menu1 },
 { "thing 2", NULL, NULL },
 { NULL, NULL, NULL },
};

int button_exit_func(void)
{
   exit_flag = TRUE;

   return 0;
}

gui_button_t button_yes = {
   "Yes",
   button_exit_func,
   8, 48,
   64, 32,
   (gui_mouse_info_t){ 0, 0, 0, 0 }
};


gui_button_t button_no = {
   "No",
   NULL,
   80, 48,
   64, 32,
   (gui_mouse_info_t){ 0, 0, 0, 0 }
};
    
gui_ctrl_t window_gui[] = {
 { gui_label,
   &(gui_label_t) {
      "Exit game?",
      8, 8,
      136, 32
    },
   0, 0 },
 { gui_button,
   &button_yes,
   0, 0 },
 { gui_button,
   &button_no,
   0, 0 },
 { NULL, NULL, 0, 0 }
};

gui_window_t main_window = {
   0, 0,
   152, 88,
   window_gui,
   0,
   (gui_mouse_info_t){ 0, 0, 0, 0 }
};
    
gui_ctrl_t main_gui[] = {
 { gui_window,
   &main_window,
   0, 0 },
 { NULL, NULL, 0, 0 }
};

int startup(void)
{
   srand(time(NULL));

   allegro_init();

   if (install_timer() < 0) {
      return 1;
   }

   if (install_mouse() < 0) {
      return 1;
   }

   if (install_keyboard() < 0) {
      return 1;
   }

   /* Timers */
   LOCK_VARIABLE(speed);
   install_int_ex(speed_regulator, BPS_TO_TIMER(30));
   LOCK_VARIABLE(cycle);
   LOCK_VARIABLE(cps);
   LOCK_VARIABLE(frame);
   LOCK_VARIABLE(fps);
   install_int_ex(persecond, BPS_TO_TIMER(1));

   /* Display */
   set_color_depth(video_depth);
   set_gfx_mode(GFX_AUTODETECT, video_w, video_h, 0, 0);
   screen_buffer = create_bitmap(video_w, video_h);

   gui_bitmap = screen_buffer;
   gui_init(main_gui);

   return 0;
}

int play(void)
{
   while(!exit_flag) {
      while (speed > 0) {
         /* Update */
         poll_mouse();
         poll_keyboard();

         if (mouse_b & 4 || key[KEY_ESC]) {
            exit_flag = TRUE;
         }
         
         if (key[KEY_C]) {
            save_bitmap("scrcap.pcx", screen_buffer, NULL);
         }
         gui_update(main_gui);
         speed--;
         cycle++;
      }

      /* Draw */
      clear(screen_buffer);
      
      /* Draw map view */
      gui_draw(main_gui);
      
      textprintf(screen_buffer, font, 0, 0, 0xffffff, "fps: %d, cps: %d", fps, cps);

      show_mouse(screen_buffer);
      vsync();
      blit(screen_buffer, screen, 0, 0, 0, 0, video_w, video_h);
      show_mouse(NULL);
      frame++;
   }

   return 0;
}

void shutdown(void)
{
   gui_clean(main_gui);

   remove_int(speed_regulator);

   destroy_bitmap(screen_buffer);
}

int main(void)
{
   if (startup()) {
      return EXIT_FAILURE;
   }
   if (play()) {
      return EXIT_FAILURE;
   }
   shutdown();

   return EXIT_SUCCESS;
}
END_OF_MAIN();
