#include "drawing.h"

#include "gui.h"

gui_draw_info_t *gui_draw_info = NULL;

/*gui_draw_info_t draw_info = {
 {  63, 127, 191,   0 },
 { 127, 191, 255,   0 },
 {   0,  63, 127,   0 },
 { 127, 191, 255,   0 },
 { 191, 255, 255,   0 },
 {  63, 127, 191,   0 },
 {  63, 127, 191,   0 },
 { 127, 191, 255,   0 },
 {   0,  63, 127,   0 },
 { 127, 191, 255,   0 },
 { 191, 255, 255,   0 },
 {  63, 127, 191,   0 },
 { 255, 255, 255,   0 },
 {   0,   0,   0,   0 }
};*/

gui_draw_info_t draw_info = {
/* Button */
 { 127, 127, 127,   0 },
 { 191, 191, 191,   0 },
 {  95,  95,  95,   0 },
 { 255, 255, 255,   0 },
/* Field */
 { 255, 255, 255,   0 },
 { 191, 191, 191,   0 },
 {  95,  95,  95,   0 },
 {   0,   0,   0,   0 }
};

void align(const int x1, const int y1, const int x2, const int y2, const int w, const int h, const int halign, const int valign, int * const x, int * const y)
{
   int area_w, area_h;

   area_w = x2 - x1;
   area_h = y2 - y1;

   switch (halign) {
   default:
   case GUI_LEFT:
      *x = x1;
      break;
   case GUI_CENTRE:
      *x = x1 + area_w / 2 - w / 2;
      break;
   case GUI_RIGHT:
      *x = x2 - w;
      break;
   }

   switch (valign) {
   default:
   case GUI_TOP:
      *y = y1;
      break;
   case GUI_MIDDLE:
      *y = y1 + area_h / 2 - h / 2;
      break;
   case GUI_BOTTOM:
      *y = y2 - h;
      break;
   }
}

void draw_text(BITMAP *dest, const FONT *fnt, const int x1, const int y1, const int x2, const int y2, const RGB colour, const int halign, const int valign, const char *str, const int type, const int style)
{
   int text_w, text_h;
   int x, y;
   int col;

   text_w = text_length(fnt, str);
   text_h = text_height(fnt);

   align(x1, y1, x2, y2, text_w, text_h, halign, valign, &x, &y);

   col = makecol_depth(bitmap_color_depth(dest), colour.r, colour.g, colour.b);

   text_mode(-1);
   textprintf(dest, fnt, x, y, col, "%s", str);
}

void gui_text(const FONT *fnt, const int x1, const int y1, const int x2, const int y2, const int halign, const int valign, const char *str, const int type, const int style)
{
   if (type) {
      draw_text(gui_bitmap, fnt, x1, y1, x2, y2, gui_draw_info->field_text, halign, valign, str, type, style);
   }
   else {
      draw_text(gui_bitmap, fnt, x1, y1, x2, y2, gui_draw_info->button_text, halign, valign, str, type, style);
   }
}

void draw_edge(BITMAP *dest, const int x1, const int y1, const int x2, const int y2, const RGB colour, const RGB highlight, const RGB shadow, const int type, const int style, const int width)
{
   int depth;
   int i;
   int top_col, left_col, bottom_col, right_col;
   int col_colour, col_highlight, col_shadow;

   depth = bitmap_color_depth(dest);

   col_colour = makecol_depth(depth, colour.r, colour.g, colour.b);
   col_highlight = makecol_depth(depth, highlight.r, highlight.g, highlight.b);
   col_shadow = makecol_depth(depth, shadow.r, shadow.g, shadow.b);

   switch (style) {
   case GUI_EDGE_STYLE_FLAT:
      top_col = col_colour;
      left_col = col_colour;
      bottom_col = col_colour;
      right_col = col_colour;
      break;
   case GUI_EDGE_STYLE_IN:
      top_col = col_shadow;
      left_col = col_shadow;
      bottom_col = col_highlight;
      right_col = col_highlight;
      break;
   case GUI_EDGE_STYLE_OUT:
      top_col = col_highlight;
      left_col = col_highlight;
      bottom_col = col_shadow;
      right_col = col_shadow;
      break;
   default:
   case GUI_EDGE_STYLE_NONE:
      break;
   }

   if (style != GUI_EDGE_STYLE_NONE) {
      for (i = 0; i < width; i++) {
         hline(dest, x1 + i, y1 + i, x2 - i - 1, top_col);
         vline(dest, x1 + i, y1 + i, y2 - i - 1, left_col);
         hline(dest, x1 + i + 1, y2 - i, x2 - i, bottom_col);
         vline(dest, x2 - i, y1 + i + 1, y2 - i, right_col);
      }
   }
}

void gui_edge(const int x1, const int y1, const int x2, const int y2, const int type, const int style)
{
   if (type) {
      draw_edge(gui_bitmap, x1, y1, x2, y2, gui_draw_info->field_area, gui_draw_info->field_highlight, gui_draw_info->field_shadow, type, style, 1);
   }
   else {
      draw_edge(gui_bitmap, x1, y1, x2, y2, gui_draw_info->button_area, gui_draw_info->button_highlight, gui_draw_info->button_shadow, type, style, 1);
   }
}

void draw_area(BITMAP *dest, const int x1, const int y1, const int x2, const int y2, const RGB colour, const RGB highlight, const RGB shadow, const int type, const int style)
{
   int col_colour, col_highlight, col_shadow;
   int depth;

   depth = bitmap_color_depth(dest);

   col_colour = makecol_depth(depth, colour.r, colour.g, colour.b);
   col_highlight = makecol_depth(depth, highlight.r, highlight.g, highlight.b);
   col_shadow = makecol_depth(depth, shadow.r, shadow.g, shadow.b);

   rectfill(dest, x1, y1, x2, y2, col_colour);
}

void gui_area(const int x1, const int y1, const int x2, const int y2, const int type, const int style)
{
   if (type) {
      draw_area(gui_bitmap, x1, y1, x2, y2, gui_draw_info->field_area, gui_draw_info->field_highlight, gui_draw_info->field_shadow, type, style);
   }
   else {
      draw_area(gui_bitmap, x1, y1, x2, y2, gui_draw_info->button_area, gui_draw_info->button_highlight, gui_draw_info->button_shadow, type, style);
   }
}

void gui_box(const int x1, const int y1, const int x2, const int y2, const int type, const int area_style, const int edge_style)
{
   gui_area(x1, y1, x2, y2, type, area_style);
   gui_edge(x1, y1, x2, y2, type, edge_style);
}

