#include "flag.h"

#include <allegro.h>

int flag_pos = FLAG_VALUE;

int flag_get(int *flags, int pos)
{
   int val;

   if (flag_pos) {
      val = 1 << pos;
   }
   else {
      val = pos;
   }

   if (*flags & val) {
      return TRUE;
   }

   return FALSE;
}

void flag_on(int *flags, int pos)
{
   int val;

   if (flag_pos) {
      val = 1 << pos;
   }
   else {
      val = pos;
   }

   *flags |= val;
}

void flag_off(int *flags, int pos)
{
   int val;

   if (flag_pos) {
      val = 1 << pos;
   }
   else {
      val = pos;
   }

   *flags |= val;
   *flags ^= val;
}

void flag_toggle(int *flags, int pos)
{
   int val;

   if (flag_pos) {
      val = 1 << pos;
   }
   else {
      val = pos;
   }

   *flags ^= val;
}

