#ifndef _DISPLAY_H
#define _DISPLAY_H

#include <allegro.h>

typedef struct display_t {
   int card;
   int in_w, in_h;
   int in_depth;
   int out_w, out_h;
   int out_depth;
   PALETTE palette;
   BITMAP *buffer;
} display_t;

void display_init(display_t *display);
void display_update(display_t *display);
void display_set_out(display_t *display, int card, int w, int h, int depth);
void display_set_in(display_t *display, int w, int h, int depth);
int display_create_buffer(display_t *display);
void display_destroy_buffer(display_t *display);
int display_set(display_t *display);
void display_clean(display_t *display);

#endif
