#include "army.h"

#include <stdlib.h>

#include "unit.h"
#include "map.h"
#include "interp.h"

void put_half_pixel(BITMAP *dest, int x, int y, int colour);

army_t *army_create(void)
{
   army_t *army = NULL;

   if ((army = malloc(sizeof(army_t))) == NULL) {
      return NULL;
   }
   army_init(army);

   return army;
}

void army_clean(army_t *army)
{
   path_clean(&army->path);
}

void army_destroy(army_t **army)
{
   if (*army != NULL) {
      army_clean(*army);
      free(*army);
   }
   *army = NULL;
}

void army_init(army_t *army)
{
   int i;

   army->size = 0;
   army->side = 0;
   army->x = army->y = 0;
   army->start_x = army->start_y = 0;
   army->target_x = army->target_y = 0;
   army->sub_pos = 0.0;

   for (i = 0; i < ARMY_UNIT_SIZE; i++) {
      army->units[i] = NULL;
      army->selected[i] = 0;
   }

   path_init(&army->path);
}

void army_draw(const army_t *army, const view_t *view, float x, float y)
{
   int i;
   int j;
   float step_start_x, step_start_y;
   float step_end_x, step_end_y;
   double sub_pos[2];
   int v0_step, v1_step, v2_step, v3_step;
   double interp_x[4];
   double interp_y[4];

   float view_x, view_y;

   for (j = 0; j < army->path.size - 1; j++) {
      unit_to_view(view, army->path.steps[j].x + 0.5, army->path.steps[j].y + 0.5, &step_start_x, &step_start_y);
      unit_to_view(view, army->path.steps[j + 1].x + 0.5, army->path.steps[j + 1].y + 0.5, &step_end_x, &step_end_y);
      if (j + 1 < army->path.pos) {
         do_line(view->draw, (int)step_start_x, (int)step_start_y, (int)step_end_x, (int)step_end_y, 0xffffff, put_half_pixel);
      }
      else {
         do_line(view->draw, (int)step_start_x, (int)step_start_y, (int)step_end_x, (int)step_end_y, 0xff0000, put_half_pixel);
      }
   }

   if (army->path.size > 0)  {
      v0_step = army->path.pos - 2;
      v1_step = army->path.pos - 1;
      v2_step = army->path.pos;
      v3_step = army->path.pos + 1;

      if (v0_step < 0) v0_step = 0;
      if (v2_step > army->path.size - 1) v2_step = army->path.size - 1;
      if (v3_step > army->path.size - 1) v3_step = army->path.size - 1;

      interp_x[0] =  army->path.steps[v0_step].x;
      interp_x[1] =  army->path.steps[v1_step].x;
      interp_x[2] =  army->path.steps[v2_step].x;
      interp_x[3] =  army->path.steps[v3_step].x;
      interp_y[0] =  army->path.steps[v0_step].y;
      interp_y[1] =  army->path.steps[v1_step].y;
      interp_y[2] =  army->path.steps[v2_step].y;
      interp_y[3] =  army->path.steps[v3_step].y;

      sub_pos[0] = cubic_interp(interp_x, army->sub_pos);
      sub_pos[1] = cubic_interp(interp_y, army->sub_pos);
//      sub_pos[0] = linear_interp(interp_x + 1, army->sub_pos);
//      sub_pos[1] = linear_interp(interp_y + 1, army->sub_pos);
   }
   else {
      sub_pos[0] = x;
      sub_pos[1] = y;
   }

//   for (i = 0; i < army->size; i++) {
//      if (army->units[i] != NULL) {
////         unit_draw(army->units[i], view, x + 0.5, y + 0.5);
//         unit_draw(army->units[i], view, sub_pos[0] + 0.5, sub_pos[1] + 0.5);
//      }
//   }
   unit_draw(army->units[0], view, sub_pos[0] + 0.5, sub_pos[1] + 0.5);
   unit_to_view(view, sub_pos[0], sub_pos[1], &view_x, &view_y);
   textprintf(view->draw, font, view_x, view_y, 0xffffff, "%d", army->size);
}

void mini_army_draw(const army_t *army, const view_t *view, float x, float y)
{
   float view_x, view_y;
   int radius_x, radius_y;

   unit_to_view(view, x, y, &view_x, &view_y);

   radius_x = (int)(view->unit_w_pixels / 2);
   radius_y = (int)(view->unit_h_pixels / 2);

   ellipsefill(view->draw, (int)view_x + radius_x, (int)view_y + radius_y, radius_x, radius_y, 0xff7f7f);
   ellipse(view->draw, (int)view_x + radius_x, (int)view_y + radius_y, radius_x, radius_y, 0xff3f3f);
}

int army_read(army_t *army, FILE *file)
{
   int i;
   int unit_number;
   int pos;
   list_t *current;

   if (fread((void *)&army->size, sizeof(int), 1, file) < 1) {
      return 1;
   }
   if (fread((void *)&army->side, sizeof(int), 1, file) < 1) {
      return 1;
   }
   if (fread((void *)&army->x, sizeof(int), 1, file) < 1) {
      return 1;
   }
   if (fread((void *)&army->y, sizeof(int), 1, file) < 1) {
      return 1;
   }
   if (fread((void *)&army->start_x, sizeof(int), 1, file) < 1) {
      return 1;
   }
   if (fread((void *)&army->start_y, sizeof(int), 1, file) < 1) {
      return 1;
   }
   if (fread((void *)&army->target_x, sizeof(int), 1, file) < 1) {
      return 1;
   }
   if (fread((void *)&army->target_y, sizeof(int), 1, file) < 1) {
      return 1;
   }
   if (fread((void *)&army->sub_pos, sizeof(float), 1, file) < 1) {
      return 1;
   }

   for (i = 0; i < army->size; i++) {
      if (fread((void *)&unit_number, sizeof(int), 1, file) < 1) {
         return 1;
      }

      pos = 0;
      current = current_map->units;
      while (pos < unit_number) {
         pos++;
         current = current->next;
      }
      army->units[i] = (unit_t *)current->data;
   }

   for (i = 0; i < army->size; i++) {
      if (fread((void *)&(army->selected[i]), sizeof(int), 1, file) < 1) {
         return 1;
      }
   }

   if (path_read(&army->path, file)) {
      return 1;
   }

   return 0;
}

int army_write(army_t *army, FILE *file)
{
   int i;
   int unit_number;

   if (fwrite((void *)&army->size, sizeof(int), 1, file) < 1) {
      return 1;
   }
   if (fwrite((void *)&army->side, sizeof(int), 1, file) < 1) {
      return 1;
   }
   if (fwrite((void *)&army->x, sizeof(int), 1, file) < 1) {
      return 1;
   }
   if (fwrite((void *)&army->y, sizeof(int), 1, file) < 1) {
      return 1;
   }
   if (fwrite((void *)&army->start_x, sizeof(int), 1, file) < 1) {
      return 1;
   }
   if (fwrite((void *)&army->start_y, sizeof(int), 1, file) < 1) {
      return 1;
   }
   if (fwrite((void *)&army->target_x, sizeof(int), 1, file) < 1) {
      return 1;
   }
   if (fwrite((void *)&army->target_y, sizeof(int), 1, file) < 1) {
      return 1;
   }
   if (fwrite((void *)&army->sub_pos, sizeof(float), 1, file) < 1) {
      return 1;
   }

   for (i = 0; i < army->size; i++) {
      unit_number = list_data_pos(&(current_map->units), army->units[i]);
      if (fwrite((void *)&unit_number, sizeof(int), 1, file) < 1) {
         return 1;
      }
   }

   for (i = 0; i < army->size; i++) {
      if (fwrite((void *)&(army->selected[i]), sizeof(int), 1, file) < 1) {
         return 1;
      }
   }

   if (path_write(&army->path, file)) {
      return 1;
   }

   return 0;
}

int army_merge(army_t *army, army_t *merger)
{
   int i;
   army_t *temp;

   if (army == NULL) {
      return 1;
   }

   if (merger == NULL) {
      return 0;
   }

   if (army->size + merger->size > ARMY_UNIT_SIZE) {
      return 1;
   }

   i = 0;
   while (i < army->size + merger->size) {
      army->units[i + army->size] = merger->units[i];
      i++;
   }
   army->size += merger->size;
   temp = army_list_pop(&current_map->armies, merger);
   army_destroy(&temp);

   return 0;
}

int army_merge_selected(army_t *army, army_t *merger, int *selected)
{
   int i;
   int merge_size;
   int merge_pos;

   merge_size = 0;
   for (i = 0; i < merger->size; i++) {
      if (selected[i]) {
         merge_size++;
      }
   }

   if (army->size + merge_size > ARMY_UNIT_SIZE) {
      return 1;
   }

   merge_pos = army->size;
   while (merge_pos < merge_size) {
   }

   return 0;
}

int army_split(army_t *army, army_t *spliter, int *selected)
{

   return 0;
}

int army_list_reader(void *army, FILE *file)
{
   if (army_read((army_t *)army, file)) {
      return 1;
   }

   return 0;
}

int army_list_writer(void *army, FILE *file)
{
   if (army_write((army_t *)army, file)) {
      return 1;
   }

   return 0;
}

int army_list_read(list_t **list, FILE *file)
{
   if (list_read(list, file, sizeof(army_t), army_list_reader)) {
      return 1;
   }

   return 0;
}

int army_list_write(list_t **list, FILE *file)
{
   if (list_write(list, file, army_list_writer)) {
      return 1;
   }

   return 0;
}

army_t *army_list_push(list_t **list, army_t *army)
{
   army_t *temp = NULL;

   if ((temp = (army_t *)list_push_data(list, (void *)army, NULL)) == NULL) {
      return NULL;
   }

   return temp;
}

army_t *army_list_pop(list_t **list, army_t *army)
{
   army_t *temp = NULL;

   if ((temp = (army_t *)list_pop_data(list, (void *)army)) == NULL) {
      return NULL;
   }

   return temp;
}

void army_list_clean(list_t **list)
{
   list_clean(list, army_list_cleaner);
}

void army_list_cleaner(void *army)
{
   army_clean(army);
   free((army_t *)army);
}
