#include <stdio.h>
#include <time.h>
#include <allegro.h>
#include <string.h>
#include "apple.h"

#define MAX_APPLES    15

#define START           0
#define GRAB            1
#define GROUND          2
#define BKET          3
#define SHAZAM          4

#define ON_TREE         1
#define IN_BKET       2
#define HELD            3
#define FALLING         4
#define ON_GROUND       5

#define D_UP              1
#define D_DOWN            2

typedef struct APPLES
{
    int state;
    int x;
    int y;
} APPLES;

int ap, pp, mous_state, mous_type,frame;

char game_title[11]="Apple Drop";
DATAFILE *datafile;
BITMAP *double_buffer;
APPLES apple[MAX_APPLES];
bool main_done=false;

int cp=0;
volatile int c_x = 1;

void state_x(void)
{
	c_x=-c_x;
	if (c_x==1) 
		cp=0;
	else
		cp=1;
}

END_OF_FUNCTION(state_x);

volatile int count = 1;

void inc_count(void)
{
	count++;
}

END_OF_FUNCTION(inc_count);

int Random(int u)
{
	return rand() % u;
}


void play_music()
{

	play_midi((MIDI *)datafile[MIDI001].dat, TRUE);
}


void play_sound(int s)
{
    play_sample((SAMPLE *)datafile[SAMP001+s].dat, 255, 128, 1000, FALSE);

}


void show_score()
{
//	char msg[80];
//	text_mode(-1);
//	sprintf(msg,"Apples:%d",pp);
//	textout(double_buffer,(FONT *)datafile[FONT_01].dat,msg, 20,20,9);
}

void init_apples(void)
{
	int i=0;

	for (i=0; i<MAX_APPLES; i++)
	{
		pp++;
		apple[i].x=Random(210)+400;
		apple[i].y=Random(192);
		apple[i].state=ON_TREE;
	}
}

void draw_apples(void)
{
	int i;
	for (i=0; i<MAX_APPLES; i++)
	{
		if (apple[i].state!=IN_BKET && apple[i].state!=HELD)
		{
			draw_sprite(double_buffer,(BITMAP*)datafile[APPLE_SPRITE].dat, apple[i].x, apple[i].y);
		}
	}		
}

void draw_graphics()
{
	blit((BITMAP*)datafile[BACK01].dat, double_buffer, 0, 0, 0, 0, 640, 480);
	draw_sprite(double_buffer,(BITMAP*)datafile[CHICK].dat, 380,404);
	draw_sprite(double_buffer,(BITMAP*)datafile[BASKET].dat, 212,331);
	draw_apples();
	show_score();

	if (mous_type==0)
		draw_sprite(double_buffer,(BITMAP*)datafile[MOUSE1].dat, mouse_x,mouse_y);
    else
		draw_sprite(double_buffer,(BITMAP*)datafile[MOUSE2].dat, mouse_x,mouse_y);

	acquire_screen();
	blit(double_buffer,screen,0,0,0,0,640,480);
	release_screen();
}

void draw_chick()
{
	int dn=0,x=380,ph=0;

	while (!dn)
	{
		if (cp==0)
		{
			if (ph==0) x=x-8;
			if (ph==1) x=x+8;
			blit((BITMAP*)datafile[BACK01].dat, double_buffer, 0, 0, 0, 0, 640, 480);
			if (ph==0 || ph==2) draw_sprite(double_buffer,(BITMAP*)datafile[CHICK].dat, x,404);
			if (ph==1) draw_sprite_h_flip(double_buffer,(BITMAP*)datafile[CHICK].dat, x,404);
			acquire_screen();
			blit(double_buffer,screen,0,0,0,0,640,480);
			release_screen();
			if (x<=30) ph++;
			if (x>=500) dn=1;
			if (key[KEY_ESC]) dn=1;
			cp=1;
		}
	}
}


void release_apples(int x, int y)
{
	int i;
	for (i=0; i<MAX_APPLES; i++)
	{
		if (apple[i].state==HELD)
        {
			apple[i].state=FALLING;
			apple[i].x=x;
			apple[i].y=y;
        }
	}
	mous_type=0;
}

int drop_apples(void)
{
	int i;
	for (i=0; i<MAX_APPLES; i++)
	{
		if (apple[i].state==FALLING)
        {
			apple[i].y+=6;
			if (apple[i].x>=228 && apple[i].x<=316 &&
                apple[i].y>340 && apple[i].y<360)
            {
				pp--;
				ap++;
				apple[i].state=IN_BKET;
				play_sound(BKET);
            }
			else
			if (apple[i].y>=404)
			{
                apple[i].y=404;
				apple[i].state=ON_GROUND;
				play_sound(GROUND);
			}
			draw_apples();
			draw_graphics();
        }
	}

	if (pp==0) 
	{
		return (1);
	} 

	return(0);

}

int pick_apples(int x, int y)
{
	int i,h=100;
	for (i=0; i<MAX_APPLES; i++)
	{
		if (apple[i].state==ON_TREE || apple[i].state==ON_GROUND)
		{
			if (ABS(apple[i].x-x)<10 && ABS(apple[i].y-y)<10)
			{

				h=i;
			}
		}

	}

	if (h!=100)
	{
		play_sound(GRAB);
		apple[h].state=HELD;
		mous_type=1;
	}

	return h;
}

void shazam()
{
	int dn=0;
	play_sound(SHAZAM);
	acquire_screen();
	blit((BITMAP *)datafile[GAMEOVER].dat,screen,0,0,0,0,640,480);
	release_screen();
	while (!dn)
	{
		if (mouse_b & 1) {dn=1;}
		if (key[KEY_ESC]) {dn=1;}
	}
}

void do_end()
{
	main_done=true;
}

int main()
{ 
	int p=0,dn=0;

	allegro_init();
	install_keyboard(); 
	install_mouse();
	install_timer();

	srand( (unsigned)time( NULL ) );
	
	set_window_title("Apple Game");

	if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0) 
	{
		allegro_message("Error initialising sound system\n%s\n", allegro_error);
        return 1;
    }


	set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);


	double_buffer = create_bitmap(640,480);

	datafile=load_datafile("apple.dat");

	set_pallete((RGB *)datafile[PALETTE_01].dat);

	acquire_screen();
	blit((BITMAP *)datafile[OPEN].dat, screen, 0, 0,0,0,640,480);
	release_screen();

	
	while (!(mouse_b & 1)) 
	{
	}
   
	LOCK_VARIABLE(c_x);
	LOCK_FUNCTION(state_x);

 	install_int(state_x, 10);

	LOCK_VARIABLE(count);
	LOCK_FUNCTION(inc_count);

 	install_int(inc_count, 1000);

	frame=0;
	while (!main_done)
	{
		ap=0;pp=0;mous_state=D_UP;mous_type=0;
		init_apples();
		play_sound(START);

		draw_graphics();

		while (!dn && !main_done)
		{
			if ((mouse_b & 1) && mous_state==D_UP)
			{
				mous_state=D_DOWN;
                pick_apples(mouse_x,mouse_y);
			}
			if (!(mouse_b & 1) && mous_state==D_DOWN)
			{
                mous_state=D_UP;
                release_apples(mouse_x,mouse_y);
			}


			p=drop_apples();

			draw_graphics();

			if (p==1) 
			{
				draw_chick();
				shazam();
				dn=1;
			}

			if (key[KEY_ESC])  
			{
				main_done=true;
			}

		}

		dn=0;
	}

	int c=count;

	rest(500);

	acquire_screen();
	clear(screen);
	release_screen();

	clear_keybuf();
 	unload_datafile(datafile);
	destroy_bitmap(double_buffer);
	
	return 0;
}

END_OF_MAIN();
