#ifndef _DEFINES_H
#define _DEFINES_H

#ifdef _DEBUG
#define while( x )                  while( ( x ) && !( key[ KEY_X ] && ( key[ KEY_LCONTROL ] || key[ KEY_RCONTROL ] ) ) )
#endif

#define gameVersion                 DAT_ID( 0, 0, 0, 1 )

#define gameTitle                   ((char*)"Sudoku")
#define gameWindowTitle             ((char*)"Sudoku by Daniel Harmon")
#define gameAuthor                  ((char*)"Daniel Harmon")
#define dataFile                    ((char*)"data/sudoku.dat")
#define configFile                  ((char*)"sudoku.ini")
#define saveGameFile                ((char*)"sudoku.gsv")
#define textNull                    ((char*)"(-----)")
#define numberOutput                ((char*)"%X")
#define genText                     ((char*)"imports/generator.%s")
#define themeText                   ((char*)"themes/%s.%s")
#define langText                    ((char*)"lang/text.%s")
#define emptyString                 ""

#define addError( x )               (-(errorList[ errorIndex++ ] = x))

#ifdef ALLEGRO_WINDOWS
#define dllExtension                ((char*)"dll")
#else
#define dllExtension                ((char*)"so")
#endif

#define defaultScreen               false
#define defaultDepth                -1
#define defaultWidth                640
#define defaultHeight               480
#define defaultBackupScreen         true
#define defaultBackupWidth          800
#define defaultBackupHeight         600
#define defaultAllowCheat           false
#define defaultAllowTicks           false
#define defaultShowTime             false
#define defaultShowCorrect          false
#define defaultShowChoices          false
#define defaultLanguage             "en"
#define defaultTheme                "emerald"


#define screenWidth                 640
#define screenHeight                480
#define squareSize                  3
#define gridSize                    9
#define boardSize                   81
#define maxQuestionButton           4

enum ErrorList
{
    ER_NONE,
    ER_ALLEGRO_INIT,
    ER_KEYBOARD_INSTALL,
    ER_TIMER_INSTALL,
    ER_MOUSE_INSTALL,    
    ER_SOUND_INSTALL,
    ER_GRAPHICS_SET,
    ER_MODULE_ALREADY_OPENED,
    ER_MODULE_LOAD,
    ER_GENERATOR_MODULE_LOAD,
    ER_GENERATOR_FUNCTION_LOAD,
    ER_THEME_MODULE_LOAD,
    ER_THEME_FUNCTION_LOAD,
    ER_THEME_INIT,
    ER_DOUBLEBUFFER_CREATE,
    ER_DATAFILE_LOAD,
    ER_TOTAL
};

enum TextList
{
    textThemeName,
    textChooseTheme,
    textMainMenu,
    textGameOptions,
    textCompletePuzzle,
    textResetBoardQuestion,
    textNewGameQuestion,
    textLoadGameQuestion,
    textOverwriteGameQuestion,
    textQuitGameQuestion,
    textAboutGame,
    textNotValid,
    textNotUnique,
    textChooseDifficulty,
    textGeneratingPuzzle,
    textLoading,

    textYes,
    textNo,

    textBlank,
    textEasy,
    textMedium,
    textHard,

    textTime,
    textStart,
    textPause,
    textUndo,
    textReset,
    textShowticks,

    textMenu,
    textResumeGame,
    textNewGame,
    textLoadGame,
    textSaveGame,
    textOptions,
    textChangeTheme,
    textAbout,
    textQuit,

    textGameSettings,
    textAllowCheat,
    textAllowPencilMarks,
    textShowTime,
    textShowIfCorrect,
    textScreenSettings,
    text640X480,
    text800X600,
    text1024X768,
    textFullscreen,
    textOk,

    textUp,
    textDown,
    textCancel,

    textResume,

    textTotalCount
};

enum GameStates
{
    GS_GAME         = 0x01,
    GS_MAINMENU     = 0x02,
    GS_THEMEMENU    = 0x04,
    GS_GAMESETTINGS = 0x08,
    GS_QUESTION     = 0x10,
    GS_CLOSEHOOK    = 0x20
};


enum GameButtons
{
    B_GAME_PAUSE,
    B_GAME_UNDO,
    B_GAME_RESET,
    B_GAME_SHOWTICK,
    B_GAME_MENU,

    B_MENU_RESUME,
    B_MENU_NEW,
    B_MENU_LOAD,
    B_MENU_SAVE,
    B_MENU_OPTIONS,
    B_MENU_CHANGETHEME,
    B_MENU_ABOUT,
    B_MENU_QUIT,

    B_OPTIONS_GAMESETTINGS,
    B_OPTIONS_ALLOWCHEAT,
    B_OPTIONS_ALLOWMARKS,
    B_OPTIONS_SHOWTIME,
    B_OPTIONS_SHOWCORRECT,
    B_OPTIONS_SCREENSETTINGS,
    B_OPTIONS_640X480,
    B_OPTIONS_800X600,
    B_OPTIONS_1024X768,
    B_OPTIONS_FULLSCREEN,
    B_OPTIONS_OK,

    B_THEME_UP,
    B_THEME_DOWN,
    B_THEME_CANCEL,
    B_THEME_OK,

    B_COUNT,

    B_CHOOSE_LEVEL = B_COUNT,
    B_KEY_NEW_GAME,
    B_KEY_LOAD_GAME,
    B_KEY_SAVE_GAME,
    B_CLOSE_HOOK,
    B_LOAD_GAME,
    B_SAVE_GAME,
};

enum Difficulties
{
    levelBlank,
    levelEasy,
    levelMedium,
    levelHard
};

enum MousePointers
{
    MP_ARROW,
    MP_HAND,
    MP_COUNT
};

enum RectStyles
{
    R_NORMAL,
    R_OVER,
    R_BLOCK,
    R_SELECTION,
    R_SELECTIONOVER,
    R_BUTTONUP,
    R_BUTTONDOWN,
    R_TIME,
    R_SHOWTICKS,
    R_COUNT
};

enum TextStyles
{
    T_NORMAL,
    T_SOLID,
    T_TICKS,
    T_SMALL,
    T_TIME,
    T_HIGHLIGHT,
    T_CORRECT,
    T_COUNT
};

enum ColorsChoices
{
    C_NORMAL,
    C_SOLID,
    C_TICKS,
    C_SMALL,
    C_TIME,
    C_HIGHLIGHT,
    C_CORRECT,
    C_BACKGROUND,
    C_OVER,
    C_BORDER,
    C_COUNT
};

enum ButtonStyles
{
    BS_NORMAL   = 0x01,
    BS_OVER     = 0x02,
    BS_DOWN     = 0x04,
    BS_DISABLED = 0x08,
    BS_UNPAUSE  = 0x10
};

enum ButtonTypes
{
    BT_DUD,
    BT_NORMAL,
    BT_LARGE,
    BT_CHECK,
    BT_RADIO
};

enum ThemeFlags
{
    TF_NORMAL  = 15,
    TF_OVER    = 16,
    TF_CURRENT = 32,
    TF_BOTH    = 64
};

typedef volatile int vint;

typedef struct RectInfo
{
    int x;
    int y;
    int width;
    int height;
} RectInfo;

typedef struct ButtonInfo
{
    RectInfo rectInfo;
    char text[ 20 ];
    int type;
    int flags;
    int index;

} ButtonInfo;

typedef struct BoardInfo
{
    RectInfo rectInfo;
    int selectWidth;
    int selectHeight;
} BoardInfo;

typedef struct CellInfo
{
    RectInfo rectInfo;
    int row;
    int col;
} CellInfo;


typedef struct QuestionInfo
{
    RectInfo rectInfo;
    char text[ 1024 ];
    int count;
    ButtonInfo button[ maxQuestionButton ];

} QuestionInfo;

typedef struct GameInfo
{
    BoardInfo       board;
    ButtonInfo      button[ B_COUNT ];
    CellInfo        cell[ gridSize ][ gridSize ];
} GameInfo;

typedef struct ThemeInfo
{
    char themeName[ 128 ];
    char filename[ 128 ];
} ThemeInfo;


#endif

