#pragma warning( disable: 4312 )

#include <allegro.h>
#include <stdio.h>
#include <string>
#include <common.h>
#include "azure.h"

#define borderLarge     2 
#define borderSmall     0
#define boardFrameX     166
#define boardFrameY     6
#define boardPositionX  182
#define boardPositionY  22
#define timeX           37
#define timeY           147
#define timeWidth       94
#define timeHeight      24
#define tickX           28
#define tickY           352
#define tickWidth       16
#define tickHeight      16


DATAFILE *data          = NULL;

enum MenuColors
{
    MC_LIGHT,
    MC_DARK,
    MC_BUTTON_LIGHT,
    MC_BUTTON_MED,
    MC_BUTTON_DARK,
    MC_COUNT
};

BITMAP *logo                     = NULL;
BITMAP *boardFrame               = NULL;
BITMAP *buttonFrame              = NULL;
BITMAP *themeFrame               = NULL;
BITMAP *buttonFrameMenu          = NULL;
BITMAP *squares[ R_COUNT ]       = { NULL, NULL, NULL, NULL, NULL };
FONT *fonts[ T_COUNT ]           = { NULL, NULL, NULL, NULL, NULL, NULL, NULL };
FONT *fontTextSmall = NULL;
FONT *fontTextRegular = NULL;
FONT *fontTextLarge = NULL;
int colors[ C_COUNT ]            = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
int menuColors[ MC_COUNT ]       = { 0, 0, 0, 0, 0 };

GameInfo *gameinfo = NULL;

/****************************************************************************** 
 ****************************************************************************** 
 ******************************************************************************/

void unloadTheme();

int initTheme();
void uninitTheme();

char* getName();
BITMAP *getScreenshot();

void getGameInfo( GameInfo &info );
void getThemeRectInfo( RectInfo &info, int index );

void setQuestionText( QuestionInfo &question, char *text, char *buttonText[ maxQuestionButton ] );

void drawScreen( BITMAP *bitmap );
void drawBackground( BITMAP *bitmap );
void drawBoard( BITMAP *bitmap );
void drawGenerating( BITMAP *bitmap, char *text );
void drawTicks( BITMAP *bitmap, int x, int y, char ticks[ gridSize ] );
void drawCell( BITMAP *bitmap, int x, int y, int value, int rectStyle, int textStyle );
void drawSelection( BITMAP *bitmap, int x, int y, int value, int rectStyle, int textStyle );
void drawButton( BITMAP *bitmap, ButtonInfo &button );
void drawTime( BITMAP *bitmap, char *text, bool show, long amount );
void drawMainMenu( BITMAP *bitmap, char *title );
void drawGameSettings( BITMAP *bitmap, char *title );
void drawThemeChoose( BITMAP *bitmap, BITMAP *screenShot, char *title );
void drawQuestion( BITMAP *bitmap, QuestionInfo &question );
void drawThemeInfo( BITMAP *bitmap, ThemeInfo &themeInfo, int index );

void fillBitmap( BITMAP *source, BITMAP *dest );
void drawRect( BITMAP *bitmap, int x, int y, int w, int h, int rectStyle );
void text( BITMAP *bitmap, FONT *font, char *text, int x, int y, int color );
void textHCentered( BITMAP *bitmap, FONT *font, char *text, int x, int y, int color );
void textVCentered( BITMAP *bitmap, FONT *font, char *text, int x, int y, int color );
void textHVCentered( BITMAP *bitmap, FONT *font, char *text, int x, int y, int color );
void textFormat( BITMAP *bitmap, FONT *font, int x, int y, int color, char *format, ... );
void textHCenteredFormat( BITMAP *bitmap, FONT *font, int x, int y, int color, char *format, ... );
void textVCenteredFormat( BITMAP *bitmap, FONT *font, int x, int y, int color, char *format, ... );
void textHVCenteredFormat( BITMAP *bitmap, FONT *font, int x, int y, int color, char *format, ... );

/****************************************************************************** 
 ****************************************************************************** 
 ******************************************************************************/

GAME_FUNC( void, fillList, ( ThemeFunctions &functionList ) )
{
    functionList.unloadTheme        = unloadTheme;

    functionList.initTheme          = initTheme;
    functionList.uninitTheme        = uninitTheme;
    functionList.getName            = getName;
    functionList.getGameInfo        = getGameInfo;
    functionList.getThemeRectInfo   = getThemeRectInfo;
    functionList.getScreenshot      = getScreenshot;

    functionList.setQuestionText    = setQuestionText;

    functionList.drawScreen         = drawScreen;
    functionList.drawBackground     = drawBackground;
    functionList.drawBoard          = drawBoard;
    functionList.drawGenerating     = drawGenerating;
    functionList.drawCell           = drawCell;
    functionList.drawTicks          = drawTicks;
    functionList.drawSelection      = drawSelection;
    functionList.drawButton         = drawButton;
    functionList.drawTime           = drawTime;
    functionList.drawMainMenu       = drawMainMenu;
    functionList.drawGameSettings   = drawGameSettings;
    functionList.drawThemeChoose    = drawThemeChoose;
    functionList.drawQuestion       = drawQuestion;
    functionList.drawThemeInfo      = drawThemeInfo;
}

GAME_FUNC( int, getVersion, () )
{
    return gameVersion;
}

/****************************************************************************** 
 ****************************************************************************** 
 ******************************************************************************/

void unloadTheme()
{
}

int initTheme()
{
    if ( !( data = load_datafile( "themes/azure.dat" ) ) )
    {
        return -1;
    }
    
    logo                            = (BITMAP*)data[ BMP_LOGO ].dat;
    boardFrame                      = (BITMAP*)data[ BMP_BOARDFRAME ].dat;
    buttonFrame                     = (BITMAP*)data[ BMP_BUTTONFRAME ].dat;
    buttonFrameMenu                 = (BITMAP*)data[ BMP_BUTTONFRAMEMENU ].dat;
    themeFrame                      = (BITMAP*)data[ BMP_THEMEFRAME ].dat;

    squares[ R_NORMAL         ]     = (BITMAP*)data[ BMP_SQUARE ].dat;
    squares[ R_OVER           ]     = (BITMAP*)data[ BMP_SQUAREOVER ].dat;
    squares[ R_BLOCK          ]     = (BITMAP*)data[ BMP_SQUAREOVERBLOCK ].dat;
    squares[ R_SELECTION      ]     = (BITMAP*)data[ BMP_SELECT ].dat;
    squares[ R_SELECTIONOVER  ]     = (BITMAP*)data[ BMP_SELECTOVER ].dat;

    fonts[ T_NORMAL    ]            = (FONT*)data[ FNT_NUMBER_LARGE ].dat;
    fonts[ T_SOLID     ]            = (FONT*)data[ FNT_NUMBER_LARGE ].dat;
    fonts[ T_TICKS     ]            = (FONT*)data[ FNT_NUMBER_SMALL ].dat;
    fonts[ T_SMALL     ]            = (FONT*)data[ FNT_NUMBER_SMALL ].dat;
    fonts[ T_HIGHLIGHT ]            = (FONT*)data[ FNT_NUMBER_LARGE ].dat;
    fonts[ T_CORRECT   ]            = (FONT*)data[ FNT_NUMBER_LARGE ].dat;

    fontTextSmall                   = (FONT*)data[ FNT_TEXT_SMALL   ].dat;
    fontTextRegular                 = (FONT*)data[ FNT_TEXT_REGULAR ].dat;
    fontTextLarge                   = (FONT*)data[ FNT_TEXT_LARGE   ].dat;

    colors[ C_NORMAL     ]          = makecol( 255, 255, 255 );
    colors[ C_SOLID      ]          = makecol( 157, 215, 255 );
    colors[ C_TICKS      ]          = makecol( 255, 255, 255 );
    colors[ C_SMALL      ]          = makecol( 157, 215, 255 );
    colors[ C_TIME       ]          = makecol( 240, 228, 245 );
    colors[ C_HIGHLIGHT  ]          = makecol(   0,   0,   0 );
    colors[ C_CORRECT    ]          = makecol( 255, 200, 200 );
    colors[ C_BACKGROUND ]          = makecol(  90,  90, 185 );
    colors[ C_OVER       ]          = makecol( 160, 160, 255 );
    colors[ C_BORDER     ]          = makecol(   0,   0, 108 );

    menuColors[ MC_LIGHT        ]   = makecol( 240, 240, 245 );
    menuColors[ MC_DARK         ]   = makecol(  43,  43,  84 );
    menuColors[ MC_BUTTON_LIGHT ]   = makecol( 104, 104, 173 );
    menuColors[ MC_BUTTON_MED   ]   = makecol(  68,  68, 138 );
    menuColors[ MC_BUTTON_DARK  ]   = makecol(  16,  16,  86 );

    return 0;
}

void uninitTheme()
{
    if ( data )
    {
        unload_datafile( data );
        data = NULL;
    }
}


char* getName()
{
    static char themeName[ 1024 ] = "Azure Skies";
    return themeName;
}

BITMAP *getScreenshot()
{
    BITMAP *temp = NULL;
    DATAFILE *data = NULL;

    data = load_datafile_object( "themes/azure.dat", "BMP_SCREENSHOT" );

    if ( data )
    {
        temp = (BITMAP*)data->dat;

        data->dat = NULL;

        unload_datafile_object( data );
    }

    return temp;
}


void getGameInfo( GameInfo &info )
{
    gameinfo = &info;

    // board
    info.board.rectInfo.x       = boardPositionX;
    info.board.rectInfo.y       = boardPositionY;
    info.board.rectInfo.width   = ( ( 9 * squares[ R_NORMAL ]->w ) +
                                    ( 6 * borderSmall ) +
                                    ( 2 * borderLarge ) );
    info.board.rectInfo.height  = ( ( 9 * squares[ R_NORMAL ]->h ) +
                                    ( 6 * borderSmall ) +
                                    ( 2 * borderLarge ) );
    info.board.selectWidth      = squares[ R_SELECTION ]->w;
    info.board.selectHeight     = squares[ R_SELECTION ]->h;


    // button[ B_COUNT ]
    for ( int i = 0; i < B_COUNT; i++ )
    {       
        int buttonX[ B_COUNT ] =
        { 
            29, 29, 29, 16, 29,
            87, 329, 87, 329, 87, 329, 87, 329,
            120, 120, 120, 120, 120, 378, 378, 378, 378, 378, 266,
            47, 47, 490, 364
        };

        int buttonY[ B_COUNT ] =
        {
            184, 234, 284, 352, 420,
            183, 183, 249, 249, 315, 315, 381, 381,
            120, 145, 175, 205, 235, 120, 145, 175, 205, 265, 416,
            78, 366, 416, 416
        };

        int buttonW[ B_COUNT ] =
        {
            108, 108, 108, 16, 108,
            224, 224, 224, 224, 224, 224, 224, 224, 
            0, 16, 16, 16, 16, 0, 16, 16, 16, 16, 108,
            108, 108, 108, 108
        };

        int buttonH[ B_COUNT ] =
        {
            32, 32, 32, 16, 32,
            48, 48, 48, 48, 48, 48, 48, 48, 
            0, 16, 16, 16, 16, 0, 16, 16, 16, 16, 32,
            32, 32, 32, 32
        };

        info.button[ i ].rectInfo.x          = buttonX[ i ];
        info.button[ i ].rectInfo.y          = buttonY[ i ];
        info.button[ i ].rectInfo.width      = buttonW[ i ];
        info.button[ i ].rectInfo.height     = buttonH[ i ];
    }


    // cell[ 9 ][ 9 ]
    for ( int row = 0; row < gridSize; row++ )
    {
        for ( int col = 0; col < gridSize; col++ )
        {
            info.cell[ row ][ col ].rectInfo.x      = boardPositionX +
                                             ( col * squares[ R_NORMAL ]->w ) + 
                                             ( ( col / squareSize ) * ( borderLarge + ( squareSize - 1 ) * borderSmall ) ) + 
                                             ( borderSmall * ( col % squareSize ) );

            info.cell[ row ][ col ].rectInfo.y      = boardPositionY +
                                             ( row * squares[ R_NORMAL ]->h ) + 
                                             ( ( row / squareSize ) * ( borderLarge + ( squareSize - 1 ) * borderSmall ) ) + 
                                             ( borderSmall * ( row % squareSize ) );
            info.cell[ row ][ col ].rectInfo.width  = squares[ R_NORMAL ]->w;
            info.cell[ row ][ col ].rectInfo.height = squares[ R_NORMAL ]->h;
            info.cell[ row ][ col ].row    = row;
            info.cell[ row ][ col ].col    = col;
        }
    }
}

void getThemeRectInfo( RectInfo &info, int index )
{
    info.x = 18 + 1;
    info.y = 122 + 1 + ( index * ( 232 / 10 ) );
    info.width = 166 - 2;
    info.height = ( 232 / 10 );
}

void setQuestionText( QuestionInfo &question, char *text, char *buttonText[ maxQuestionButton ] )
{
    char *start = NULL;
    int diff = 6;
    int bHeight = 0;
    int bWidth = 0;

    strcpy( question.text, text );

    start = text = question.text;

    question.rectInfo.width = 0;
    question.rectInfo.height = 0;

    question.count = 0;

    for ( int i = 0; i < maxQuestionButton; i++ )
    {
        if ( buttonText[ i ] )
        {
            question.count++;
        }
    }

    while ( true )
    {
        char c = *text;

        if ( c == '\n' || c == '\0' )
        {
            *text = '\0';

            question.rectInfo.width = MAX( question.rectInfo.width, ( text_length( fontTextSmall, start ) + ( diff * 2 ) ) );
            question.rectInfo.height += ( text_height( fontTextSmall ) + diff );

            *text = c;
            
            if ( c == '\n' )
            {
                start = ++text;
            }
            else
            {
                break;
            }
        }
        else
        {
            text++;
        }
    }

    bWidth = MAX( 2, question.count );
    bHeight = 1 + ( ( question.count - 1 ) / 2 );


    question.rectInfo.width = MAX( question.rectInfo.width, 
                                   ( ( buttonFrame->w * bWidth ) + ( diff * ( bWidth + 1 ) ) ) );

    question.rectInfo.height += ( ( buttonFrame->h * bHeight ) + ( diff * ( bHeight + 2 ) ) );


    question.rectInfo.x = ( ( SCREEN_W - question.rectInfo.width ) / 2 );
    question.rectInfo.y = ( ( SCREEN_H - question.rectInfo.height ) / 2 );


    for ( int i = 0; i < question.count; i++ )
    {
        strcpy( question.button[ i ].text, buttonText[ i ] );
        question.button[ i ].rectInfo.width  = buttonFrame->w - ( 2 * diff );
        question.button[ i ].rectInfo.height = buttonFrame->h - ( 2 * diff );
        question.button[ i ].index           = i;
        question.button[ i ].flags           = BS_NORMAL;
        question.button[ i ].type            = BT_NORMAL;
    }

    switch( question.count )
    {
    case 1:
        {
            question.button[ 0 ].rectInfo.x = question.rectInfo.x + ( ( question.rectInfo.width - buttonFrame->w ) / 2 ) + diff;
            question.button[ 0 ].rectInfo.y = question.rectInfo.y + question.rectInfo.height - ( buttonFrame->h + diff ) + diff;
        } break;

    case 2:
        {
            question.button[ 0 ].rectInfo.x = question.rectInfo.x + ( ( question.rectInfo.width - diff ) / 2 ) - buttonFrame->w + diff;
            question.button[ 0 ].rectInfo.y = question.rectInfo.y + question.rectInfo.height - ( buttonFrame->h + diff ) + diff;

            question.button[ 1 ].rectInfo.x = question.button[ 0 ].rectInfo.x + ( buttonFrame->w + diff );
            question.button[ 1 ].rectInfo.y = question.button[ 0 ].rectInfo.y;
        } break;

    case 3:
        {
            question.button[ 0 ].rectInfo.x = question.rectInfo.x + ( ( question.rectInfo.width - diff ) / 2 ) - buttonFrame->w + diff;
            question.button[ 0 ].rectInfo.y = question.rectInfo.y + question.rectInfo.height - ( 2 * ( buttonFrame->h + diff ) ) + diff;

            question.button[ 1 ].rectInfo.x = question.button[ 0 ].rectInfo.x + ( buttonFrame->w + diff );
            question.button[ 1 ].rectInfo.y = question.button[ 0 ].rectInfo.y;

            question.button[ 2 ].rectInfo.x = question.rectInfo.x + ( ( question.rectInfo.width - buttonFrame->w ) / 2 ) + diff;
            question.button[ 2 ].rectInfo.y = question.rectInfo.y + question.rectInfo.height - ( buttonFrame->h + diff ) + diff;
        } break;

    case 4:
        {
            question.button[ 0 ].rectInfo.x = question.rectInfo.x + ( ( question.rectInfo.width - diff ) / 2 ) - buttonFrame->w + diff;
            question.button[ 0 ].rectInfo.y = question.rectInfo.y + question.rectInfo.height - ( 2 * ( buttonFrame->h + diff ) ) + diff;

            question.button[ 1 ].rectInfo.x = question.button[ 0 ].rectInfo.x + ( buttonFrame->w + diff );
            question.button[ 1 ].rectInfo.y = question.button[ 0 ].rectInfo.y;

            question.button[ 2 ].rectInfo.x = question.rectInfo.x + ( ( question.rectInfo.width - diff ) / 2 ) - buttonFrame->w + diff;
            question.button[ 2 ].rectInfo.y = question.rectInfo.y + question.rectInfo.height - ( buttonFrame->h + diff ) + diff;

            question.button[ 3 ].rectInfo.x = question.button[ 2 ].rectInfo.x + ( buttonFrame->w + diff );
            question.button[ 3 ].rectInfo.y = question.button[ 2 ].rectInfo.y;
        } break;
    }
}

void drawScreen( BITMAP *bitmap )
{
    drawBackground( bitmap );
    draw_sprite( bitmap, logo, 6, 6 );
}

void drawBackground( BITMAP *bitmap )
{
    fillBitmap( (BITMAP*)data[ BMP_BACKGROUND ].dat, bitmap );
    //clear_to_color( bitmap, colors[ C_BACKGROUND ] );
}

void drawBoard( BITMAP *bitmap )
{
    blit( boardFrame, bitmap, 0, 0, boardFrameX, boardFrameY, boardFrame->w, boardFrame->h );

    for ( int i = B_GAME_PAUSE; i <= B_GAME_MENU; i++ )
    {
        drawButton( bitmap, gameinfo->button[ i ] );
    }
}

void drawGenerating( BITMAP *bitmap, char *text )
{
    textHVCentered( bitmap, 
                    fontTextRegular, 
                    text, 
                    boardFrameX + ( boardFrame->w / 2 ),
                    boardFrameY + ( boardFrame->h / 2 ),
                    menuColors[ MC_LIGHT ] );
}

void drawTicks( BITMAP *bitmap, int x, int y, char ticks[ gridSize ] )
{
    int tw = text_length( fonts[ T_TICKS ], "0" ) - 1;
    int th = text_height( fonts[ T_TICKS ] ) - 2;
    int dw = ( squares[ R_NORMAL ]->w - ( 3 * tw ) ) / 4;
    int dh = ( squares[ R_NORMAL ]->h - ( 3 * th ) ) / 4;

    for ( int i = 0; i < gridSize; i++ )
    {
        int p = ticks[ i ];
        int px = ( p - 1 ) % 3;
        int py = ( p - 1 ) / 3;

        if ( p != 0 )
        {
            textFormat( bitmap,
                                fonts[ T_TICKS ],
                                x + dw + px * ( tw + dw ),
                                y + dh + py * ( th + dh ),
                                menuColors[ MC_LIGHT ],
                                numberOutput,
                                p );

        }
    }
}

void drawCell( BITMAP *bitmap, int x, int y, int value, int rectStyle, int textStyle )
{
    drawRect( bitmap, x, y, squares[ rectStyle ]->w, squares[ rectStyle ]->h, rectStyle );
    if ( value )
    {
        textHVCenteredFormat( bitmap, fonts[ textStyle ], x + ( squares[ rectStyle ]->w / 2 ), y + ( squares[ rectStyle ]->h / 2 ), colors[ textStyle ], numberOutput, value );
    }
}

void drawSelection( BITMAP *bitmap, int x, int y, int value, int rectStyle, int textStyle )
{
    drawRect( bitmap, x, y, squares[ rectStyle ]->w, squares[ rectStyle ]->h, rectStyle );
    if ( value )
    {
        textHVCenteredFormat( bitmap, fonts[ textStyle ], x + ( squares[ rectStyle ]->w / 2 ), y + ( squares[ rectStyle ]->h / 2 ), colors[ textStyle ], numberOutput, value );
    }
}

void drawButton( BITMAP *bitmap, ButtonInfo &button )
{
    if ( button.type == BT_DUD )
    {
        textVCentered( bitmap, 
              fontTextRegular, 
              button.text, 
              button.rectInfo.x, 
              button.rectInfo.y, 
              menuColors[ MC_LIGHT ] );
        return;
    }

    if ( button.type == BT_CHECK || button.type == BT_RADIO )
    {           
        if ( button.type == BT_RADIO )
        {
            circlefill( bitmap, 
                    button.rectInfo.x + ( button.rectInfo.width / 2 ), 
                    button.rectInfo.y + ( button.rectInfo.height / 2 ), 
                    ( button.rectInfo.width / 2 ), 
                    menuColors[ MC_DARK ] );

            circle( bitmap, 
                    button.rectInfo.x + ( button.rectInfo.width / 2 ), 
                    button.rectInfo.y + ( button.rectInfo.height / 2 ), 
                    ( button.rectInfo.width / 2 ),
                    menuColors[ MC_LIGHT ] );
        }
        else
        {
            rectfill( bitmap, 
                    button.rectInfo.x, 
                    button.rectInfo.y, 
                    button.rectInfo.x + button.rectInfo.width - 1, 
                    button.rectInfo.y + button.rectInfo.height - 1, 
                    menuColors[ MC_DARK ] );

            rect( bitmap, 
                    button.rectInfo.x, 
                    button.rectInfo.y, 
                    button.rectInfo.x + button.rectInfo.width - 1, 
                    button.rectInfo.y + button.rectInfo.height - 1, 
                    menuColors[ MC_LIGHT ] );
        }

        if ( button.flags & BS_DOWN )
        {
            int color1 = MC_LIGHT;
            int color2 = MC_LIGHT;

            if ( button.flags & BS_DISABLED )
            {
                color1 = MC_BUTTON_LIGHT;
                color2 = MC_BUTTON_LIGHT;
            }

            line( bitmap, 
                  button.rectInfo.x + 4, 
                  button.rectInfo.y + 4, 
                  button.rectInfo.x + button.rectInfo.width - ( 4 + 1 ), 
                  button.rectInfo.y + button.rectInfo.height - ( 4 + 1 ),  
                  menuColors[ color1 ] );
            line( bitmap, 
                  button.rectInfo.x + 4, 
                  button.rectInfo.y + button.rectInfo.height - ( 4 + 1 ), 
                  button.rectInfo.x + button.rectInfo.width - ( 4 + 1 ), 
                  button.rectInfo.y + 4,  
                  menuColors[ color2 ] );
        }

        textVCentered( bitmap, 
                       fontTextSmall, 
                       button.text, 
                       button.rectInfo.x + button.rectInfo.width + 4, 
                       button.rectInfo.y + ( button.rectInfo.height / 2 ), 
                       menuColors[ MC_LIGHT ] );
    }
    else
    {
        BITMAP *buttonBitmap = buttonFrame;
        FONT *tfont = fontTextSmall;
        char *text = button.text;
        int delta = 0;
        int textColor = MC_LIGHT;
        int topleft = MC_BUTTON_LIGHT;
        int bottomright = MC_BUTTON_DARK;

        if ( button.flags & BS_DOWN )
        {
            topleft = MC_BUTTON_DARK;
            bottomright = MC_BUTTON_LIGHT; 
            delta = 1;
        }        
        
        if ( button.flags & BS_DISABLED )
        {
            textColor = MC_BUTTON_DARK;
            topleft = MC_BUTTON_LIGHT;
            bottomright = MC_BUTTON_DARK;
        }

        if ( button.type == BT_LARGE )
        {
            tfont = fontTextRegular;
            buttonBitmap = buttonFrameMenu;
        }

        draw_sprite( bitmap, 
                     buttonBitmap, 
                     button.rectInfo.x - 6, 
                     button.rectInfo.y - 6 );
        
        rectfill( bitmap, 
                  button.rectInfo.x, 
                  button.rectInfo.y, 
                  button.rectInfo.x + button.rectInfo.width - 1, 
                  button.rectInfo.y + button.rectInfo.height - 1, 
                  menuColors[ MC_BUTTON_MED ] );

        rect( bitmap, 
              button.rectInfo.x + 1, 
              button.rectInfo.y + 1, 
              button.rectInfo.x + button.rectInfo.width - 2, 
              button.rectInfo.y + button.rectInfo.height - 2, 
              menuColors[ bottomright ] );

        line( bitmap, 
              button.rectInfo.x + 1, 
              button.rectInfo.y + 1, 
              button.rectInfo.x + 1, 
              button.rectInfo.y + button.rectInfo.height - 2, 
              menuColors[ topleft ] );

        line( bitmap, 
              button.rectInfo.x + 1, 
              button.rectInfo.y + 1, 
              button.rectInfo.x + button.rectInfo.width - 2, 
              button.rectInfo.y + 1, 
              menuColors[ topleft ] );

        textHVCentered( bitmap, 
                        tfont, 
                        text, 
                        button.rectInfo.x + ( button.rectInfo.width / 2 ) + delta, 
                        button.rectInfo.y + ( button.rectInfo.height / 2 ) + delta, 
                        menuColors[ textColor ] );
    }
}

void drawTime( BITMAP *bitmap, char *text, bool show, long amount )
{
    static char timeText[ 64 ] = emptyString;
    static int hr = 0;
    static int min = 0;
    static int sec = 0;

    amount = MIN( amount, 3599999 );
    sec = ( amount % 60 );
    min = ( amount / 60 );
    hr = ( min / 60 );

    sprintf( timeText, "%02d:%02d:%02d", hr, min % 60, sec % 60 );

    drawRect( bitmap, 
              timeX, 
              timeY, 
              timeWidth, 
              timeHeight, 
              R_TIME );

    if ( show )
    {
        textHVCentered( bitmap, fontTextSmall, timeText, timeX + timeWidth / 2, timeY + timeHeight / 2, menuColors[ MC_LIGHT ] );
    }

    textHVCentered( bitmap, 
                    fontTextSmall, 
                    text, 
                    timeX + timeWidth / 2, 
                    timeY - ( timeHeight / 2 ), 
                    menuColors[ MC_LIGHT ] );
}

void drawMainMenu( BITMAP *bitmap, char *title )
{
    drawBackground( bitmap );

    textHCentered( bitmap, 
                   fontTextLarge, 
                   title, 
                   bitmap->w / 2, 
                   0,
                   menuColors[ MC_LIGHT ] );



    for ( int i = B_MENU_RESUME; i <= B_MENU_QUIT; i++ )
    {
        drawButton( bitmap, gameinfo->button[ i ] );
    }
}

void drawGameSettings( BITMAP *bitmap, char *title )
{
    drawBackground( bitmap );

    textHCentered( bitmap, 
                   fontTextLarge, 
                   title, 
                   bitmap->w / 2, 
                   0,
                   menuColors[ MC_LIGHT ] );

    for ( int i = B_OPTIONS_GAMESETTINGS; i <= B_OPTIONS_OK; i++ )
    {
        drawButton( bitmap, gameinfo->button[ i ] );
    }
}

void drawThemeChoose( BITMAP *bitmap, BITMAP *screenShot, char *title )
{
    drawBackground( bitmap );

    textHCentered( bitmap, 
                   fontTextLarge, 
                   title, 
                   bitmap->w / 2, 
                   0,
                   menuColors[ MC_LIGHT ] );

    draw_sprite( bitmap, themeFrame, 202, 72 );
    drawRect( bitmap, 18, 122, 166, 232, R_TIME );
            
    for ( int i = B_THEME_UP; i <= B_THEME_OK; i++ )
    {
        drawButton( bitmap, gameinfo->button[ i ] );
    }

    if ( screenShot )
    {
        if ( screenShot->w == 400 &&
             screenShot->h == 300 )
        {
            blit( screenShot, 
                bitmap, 
                0, 
                0, 
                218, 
                88, 
                400, 
                300 );
        }
        else
        {
            stretch_blit( screenShot, 
                        bitmap, 
                        0, 
                        0, 
                        screenShot->w, 
                        screenShot->h, 
                        218, 
                        88, 
                        400, 
                        300 );
        }
    }
    else
    {
        textHVCentered( bitmap, fontTextSmall, "No Screenshot", 218 + 200, 88 + 150, menuColors[ MC_LIGHT ] );
    }
}

void drawQuestion( BITMAP *bitmap, QuestionInfo &question )
{
    char *text = NULL;
    char *start = NULL;
    int y = question.rectInfo.y + 6;

    start = text = question.text;

    drawRect( bitmap, 
              question.rectInfo.x, 
              question.rectInfo.y, 
              question.rectInfo.width, 
              question.rectInfo.height, 
              R_TIME );
 
    while ( true )
    {
        char c = *text;

        if ( c == '\n' || c == '\0' )
        {
            *text = '\0';

            textHCentered( bitmap, 
                           fontTextSmall, 
                           start, 
                           question.rectInfo.x + ( question.rectInfo.width / 2 ), 
                           y, 
                           colors[ C_TIME ] );
            y += ( text_height( fontTextSmall ) + 6 );

            *text = c;
            
            if ( c == '\n' )
            {
                start = ++text;
            }
            else
            {
                break;
            }
        }
        else
        {
            text++;
        }
    }

    for ( int i = 0; i < question.count; i++ )
    {
        drawButton( bitmap, question.button[ i ] );
    }
}

void drawThemeInfo( BITMAP *bitmap, ThemeInfo &themeInfo, int index )
{
    static RectInfo rect;
    int i = ( index & TF_NORMAL );
    int rectColor = menuColors[ MC_DARK ];
    int textColor = colors[ C_NORMAL ];

    getThemeRectInfo( rect, i );

    if ( index & TF_OVER )
    {
        rectColor = menuColors[ MC_BUTTON_MED ];
    }

    if ( index & TF_CURRENT )
    {
        rectColor = menuColors[ MC_BUTTON_LIGHT ];
        textColor = menuColors[ MC_DARK ];
    }

    if ( index & TF_BOTH )
    {
        rectColor = colors[ T_SOLID ];
        textColor = menuColors[ MC_DARK ];
    }

    rectfill( bitmap, 
                rect.x, 
                rect.y, 
                rect.x + rect.width - 1, 
                rect.y + rect.height - 1, 
                rectColor );

    textHVCentered( bitmap, 
                    fontTextSmall, 
                    themeInfo.themeName, 
                    rect.x + ( rect.width / 2 ), 
                    rect.y + ( rect.height / 2 ), 
                    textColor );
}


/****************************************************************************** 
 ****************************************************************************** 
 ******************************************************************************/

void fillBitmap( BITMAP *source, BITMAP *dest )
{
    for ( int j = 0; j < dest->h; j += source->h )
    {
        for ( int i = 0; i < dest->w; i += source->w )
        {
            blit( source, dest, 0, 0, i, j, MIN( source->w, dest->w - i ), MIN( source->h, dest->h - j ) );
        }
    }
}

void drawRect( BITMAP *bitmap, int x, int y, int w, int h, int rectStyle )
{
    if ( rectStyle >= R_NORMAL && 
         rectStyle < R_COUNT )
    {
        switch( rectStyle )
        {
        case R_BUTTONUP:
            {
                draw_sprite( bitmap, buttonFrame, x - 6, y - 6 );
                rectfill( bitmap, x, y, x + w - 1, y + h - 1, menuColors[ MC_BUTTON_MED ] );
                rect( bitmap, x + 1, y + 1, x + w - 2, y + h - 2, menuColors[ MC_BUTTON_DARK ] );
                rect( bitmap, x + 1, y + 1, x + w - 2, y + 1, menuColors[ MC_BUTTON_LIGHT ] );
                line( bitmap, x + 1, y + 1, x + 1, y + h - 2, menuColors[ MC_BUTTON_LIGHT ] );
            } break;

        case R_BUTTONDOWN:
            {
                draw_sprite( bitmap, buttonFrame, x - 6, y - 6 );
                rectfill( bitmap, x, y, x + w - 1, y + h - 1, menuColors[ MC_BUTTON_MED ] );
                rect( bitmap, x + 1, y + 1, x + w - 2, y + h - 2, menuColors[ MC_BUTTON_LIGHT ] );
                rect( bitmap, x + 1, y + 1, x + w - 2, y + 1, menuColors[ MC_BUTTON_DARK ] );
                line( bitmap, x + 1, y + 1, x + 1, y + h - 2, menuColors[ MC_BUTTON_DARK ] );
            } break;

        case R_TIME:
        case R_SHOWTICKS:
            {
                rectfill( bitmap, x, y, x + w - 1, y + h - 1, menuColors[ MC_DARK ] );
                rect( bitmap, x, y, x + w - 1, y + h - 1, menuColors[ MC_LIGHT ] );
            } break;

        default:
            {
                draw_sprite( bitmap, squares[ rectStyle ], x, y );
            } break;
        }
    }
}

void text( BITMAP *bitmap, FONT *font, char *text, int x, int y, int color )
{
    textout( bitmap, font, text, x, y, color );
}

void textHCentered( BITMAP *bitmap, FONT *font, char *text, int x, int y, int color )
{
    textout_centre( bitmap, font, text, x, y, color );
}

void textVCentered( BITMAP *bitmap, FONT *font, char *text, int x, int y, int color )
{
    int height = text_height( font );
        
    textout( bitmap, font, text, x, y - ( height / 2 ), color );
}

void textHVCentered( BITMAP *bitmap, FONT *font, char *text, int x, int y, int color )
{
    int height = text_height( font );
    
    textout_centre( bitmap, font, text, x, y - ( height / 2 ), color );
}

void textFormat( BITMAP *bitmap, FONT *font, int x, int y, int color, char *format, ... )
{
    char stringBuffer[ 1024 ];
    va_list ap;

    va_start( ap, format );
    vsprintf( stringBuffer, format, ap ); 
    va_end( ap );

    text( bitmap, font, stringBuffer, x, y, color );
}

void textHCenteredFormat( BITMAP *bitmap, FONT *font, int x, int y, int color, char *format, ... )
{
    char stringBuffer[ 1024 ];
    va_list ap;

    va_start( ap, format );
    vsprintf( stringBuffer, format, ap ); 
    va_end( ap );

    textHCentered( bitmap, font, stringBuffer, x, y, color );
}

void textVCenteredFormat( BITMAP *bitmap, FONT *font, int x, int y, int color, char *format, ... )
{
    char stringBuffer[ 1024 ];
    va_list ap;

    va_start( ap, format );
    vsprintf( stringBuffer, format, ap ); 
    va_end( ap );

    textVCentered( bitmap, font, stringBuffer, x, y, color );
}

void textHVCenteredFormat( BITMAP *bitmap, FONT *font, int x, int y, int color, char *format, ... )
{
    char stringBuffer[ 1024 ];
    va_list ap;

    va_start( ap, format );
    vsprintf( stringBuffer, format, ap ); 
    va_end( ap );

    textHVCentered( bitmap, font, stringBuffer, x, y, color );
}



