#ifdef _MSC_VER
#pragma warning( disable: 4312 )
#else
#define ALLEGRO_STATICLINK
#endif

#include <allegro.h>
#include <time.h>
#include <stdio.h>
#include <string>
#include <list>
#include "defines.h"
#include "globals.h"
#include "module.h"
#include "themefunctions.h"
#include "theme.h"
#include "themeList.h"

std::list<ThemeInfo> themeStack;

ThemeList::ThemeList()
{
    this->screenShot = NULL;
    this->count = 0;
    this->place = 0;
    this->current = -1;
    this->over = -1;
}

ThemeList::~ThemeList()
{
}


void ThemeList::addToList( const char *filename, int attrib, int param )
{
    Theme temp;
    char *extension = NULL;

    //std::list<ThemeInfo> *themeStack = (std::list<ThemeInfo>*)param;

    filename = get_filename( filename );
    extension = get_extension( filename );

    *( extension - 1 ) = '\0';

    if ( temp.load( filename ) == 0 )
    {
        ThemeInfo theme;

        strcpy( theme.filename, filename );
        strcpy( theme.themeName, temp.getName() );

        //themeStack->push_back( theme );
        themeStack.push_back( theme );

        temp.unload();
    }
}

void ThemeList::init()
{
    char fileExt[ 128 ] = emptyString;

    sprintf( fileExt, themeText, "*", dllExtension );

    this->uninit();

    for_each_file( fileExt, 
                      FA_ARCH, 
                      
                      ThemeList::addToList, 
                      
                      0 );
                      //(void*)(&this->stack) );

    this->count = (int)themeStack.size();

    if ( this->count > 0 )
    {
        std::list<ThemeInfo>::iterator it = themeStack.begin();
        
        for ( int i = 0; it != themeStack.end(); it++, i++ )
        {
            if ( stricmp( themeName, (*it).filename ) == 0 )
            {
                this->over = i;
            }
        }

        this->changeScreenShot();    
        this->over = -1;

        for ( int i = 0; i < 10; i++ )
        {
            theme.getThemeRectInfo( this->rectInfo[ i ], i );
        }
    }


}

void ThemeList::uninit()
{
    if ( this->screenShot )
    {
        destroy_bitmap( this->screenShot );
        this->screenShot = NULL;
    }

    if ( themeStack.size() > 0 )
    {
        themeStack.clear();
    }

    this->count = 0;
    this->place = 0;
    this->current = -1;
    this->over = -1;
}

void ThemeList::draw( BITMAP *bitmap )
{
    theme.drawThemeChoose( bitmap, this->screenShot, textList[ textChooseTheme ] );

    if ( themeStack.size() == 0 )
    {
        return;
    }

    std::list<ThemeInfo>::iterator it = themeStack.begin();
    for ( int i = 0; ( it != themeStack.end() && i < this->place ); it++, i++ )
    {
    }

    for ( int i = 0; ( it != themeStack.end() && i < 10 ); it++, i++ )
    {
        int index = i;

        if ( this->over == ( i + this->place ) )
        {
            index |= TF_OVER;   
        }

        if ( this->current == ( i + this->place ) )
        {
            index |= TF_CURRENT;
        }

        if ( ( index & TF_OVER ) && ( index & TF_CURRENT ) )
        {
            index |= TF_BOTH;
        }

        theme.drawThemeInfo( bitmap, 
                             (*it), 
                             index );     
    }
}

void ThemeList::logic()
{
    if ( themeStack.size() == 0 )
    {
        return;
    }

    std::list<ThemeInfo>::iterator it = themeStack.begin();

    for ( int i = 0; i < this->place; i++ )
    {
        it++;
    }

    this->over = -1;

    for ( int i = 0; i < 10; it++, i++ )
    {
        if ( it == themeStack.end() )
        {
            break;
        }

        if ( mouseX >= rectInfo[ i ].x &&
             mouseY >= rectInfo[ i ].y &&
             mouseX <  ( rectInfo[ i ].x + rectInfo[ i ].width ) &&
             mouseY <  ( rectInfo[ i ].y + rectInfo[ i ].height ) )
        {
            mousePtr = MP_HAND;

            this->over = ( i + this->place );

            if ( mouse1Clicked )
            {
                mouse1Clicked = false;
                mousePtr = MP_ARROW;

                if ( this->current != this->over )
                {
                    changeScreenShot();
                }
            }
        }
    }
}

void ThemeList::changeScreenShot()
{
    Theme tempTheme;

    if ( this->screenShot )
    {
        destroy_bitmap( this->screenShot );
        this->screenShot = NULL;
    }

    this->current = this->over;

    if ( this->getCurrentFilename() )
    {
        if ( tempTheme.load( this->getCurrentFilename() ) == 0 )
        {
            this->screenShot = tempTheme.getScreenshot();
            tempTheme.unload();
        }
    }
}

void ThemeList::moveUp()
{
    if ( this->place > 0 )
    {
        this->place--;
    }
}

void ThemeList::moveDown()
{
    if ( this->place < ( this->count - 10 ) )
    {
        this->place++;
    }
}

char *ThemeList::getCurrentFilename()
{
    if ( themeStack.size() == 0 )
    {
        return NULL;
    }

    std::list<ThemeInfo>::iterator it = themeStack.begin();
    for ( int i = 0; i < this->current; i++ )
    {
        it++;
    }

    return (*it).filename;
}

void ThemeList::apply()
{
    strcpy( themeName, currentThemeName );
}

