#ifndef _THEMEFUNCTIONS_H
#define _THEMEFUNCTIONS_H

typedef struct ThemeFunctions
{
    void    (*unloadTheme)();
    int     (*initTheme)();
    void    (*uninitTheme)();
    char*   (*getName)();
    BITMAP* (*getScreenshot)();
    void    (*getGameInfo)( GameInfo &info );
    void    (*getThemeRectInfo)( RectInfo &info, int index );
    void    (*setQuestionText)( QuestionInfo &question, char *text, char *buttonText[ maxQuestionButton ] );
    void    (*drawScreen)( BITMAP *bitmap );
    void    (*drawBackground)( BITMAP *bitmap );
    void    (*drawBoard)( BITMAP *bitmap );
    void    (*drawGenerating)( BITMAP *bitmap, char *text );
    void    (*drawTicks)( BITMAP *bitmap, int x, int y, char ticks[ gridSize ] );
    void    (*drawCell)( BITMAP *bitmap, int x, int y, int value, int rectStyle, int textStyle );
    void    (*drawSelection)( BITMAP *bitmap, int x, int y, int value, int rectStyle, int textStyle );
    void    (*drawButton)( BITMAP *bitmap, ButtonInfo &button );
    void    (*drawTime)( BITMAP *bitmap, char *text, bool show, long amount );
    void    (*drawMainMenu)( BITMAP *bitmap, char *title );
    void    (*drawGameSettings)( BITMAP *bitmap, char *title );
    void    (*drawThemeChoose)( BITMAP *bitmap, BITMAP *screenShot, char *title );
    void    (*drawQuestion)( BITMAP *bitmap, QuestionInfo &question );
    void    (*drawThemeInfo)( BITMAP *bitmap, ThemeInfo &themeInfo, int index );
} ThemeFunctions;


#endif

