#ifndef _THEME_H
#define _THEME_H

enum DrawFlags
{
    F_NORMAL,
    F_OVER,
    F_DOWN
};

class Theme
{
public:
    Theme();
    ~Theme();
    int load( AL_CONST char *name );
    
    void unload();

    int initTheme();
    void uninitTheme();


    char *getName();
    BITMAP *getScreenshot();
    void getGameInfo( GameInfo &info );
    void getThemeRectInfo( RectInfo &info, int index );


    void setQuestionText( QuestionInfo &question, char *text, char *button1, char *button2 = NULL, char *button3 = NULL, char *button4 = NULL );

    void drawScreen( BITMAP *bitmap );
    void drawBackground( BITMAP *bitmap );
    void drawBoard( BITMAP *bitmap );
    void drawGenerating( BITMAP *bitmap, char *text );
    void drawTicks( BITMAP *bitmap, int x, int y, char ticks[ gridSize ] );
    void drawCell( BITMAP *bitmap, int x, int y, int value, int rectStyle, int textStyle );
    void drawSelection( BITMAP *bitmap, int x, int y, int value, int rectStyle, int textStyle );
    void drawButton( BITMAP *bitmap, ButtonInfo &button );
    void drawTime( BITMAP *bitmap, char *text, bool show, long amount );
    void drawMainMenu( BITMAP *bitmap, char *title );
    void drawGameSettings( BITMAP *bitmap, char *title );
    void drawThemeChoose( BITMAP *bitmap, BITMAP *screenShot, char *title );
    void drawQuestion( BITMAP *bitmap, QuestionInfo &question );
    void drawThemeInfo( BITMAP *bitmap, ThemeInfo &themeInfo, int index );

private:
    Module genModule;
    ThemeFunctions functionList;

    void (*_fillList)( ThemeFunctions &functionList );
    int (*_getVersion)();

};

extern Theme theme;

#endif

