#ifndef _BOARD_H
#define _BOARD_H

class Board
{
public:
    Board();
    ~Board();
    void save( PACKFILE *pfile );
    void load( PACKFILE *pfile );
    void init();
    void solve();
    bool canUndo();
    void doUndo();
    void placeNumber( BoardCell *cell, int newvalue );
    void clear();
    void draw( BITMAP *bitmap );
    BoardCell *logic();
    int newGame( int difficulty );
    void fillInCellChoices();
    void fillTicks();
    bool filled();
    void reset();
    int activateBlankPuzzle();

private:
    int getRow( int y );
    int getCol( int x );
    bool canPutInSquare( int col, int row, char value );
    bool canPutInColumn( int col, char value );
    bool canPutInRow( int row, char value );


    BoardCell cell[ gridSize ][ gridSize ];
    int fillCount;
    int difficulty;
};

#endif

