#ifdef _MSC_VER
#pragma warning( disable: 4312 )
#else
#define ALLEGRO_STATICLINK
#endif

#include <allegro.h>

#ifdef ALLEGRO_WINDOWS
#include <winalleg.h>
#endif
#include <time.h>
#include <stdio.h>
#include <string>
#include "defines.h"
#include "globals.h"
#include "module.h"
#include "themefunctions.h"
#include "theme.h"

#include "misc.h"

void Misc::flip( BITMAP *bitmap )
{
    acquire_bitmap( screen );
    if ( bitmap->w == SCREEN_W &&
         bitmap->h == SCREEN_H )
    {
        blit( bitmap, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H );
    }
    else
    {
        stretch_blit( bitmap, screen, 0, 0, bitmap->w, bitmap->h, 0, 0, SCREEN_W, SCREEN_H );
    }
    release_bitmap( screen );
}

void Misc::sleep( int milliseconds )
{
#ifdef ALLEGRO_WINDOWS
    Sleep( milliseconds );
#else
    rest( 1 );
#endif
}

void Misc::doInput( int inVar, bool &boolVar, bool &outVar )   
{
    outVar = false;

    if ( inVar == 0 )
    {
        if( boolVar )
        {
            outVar = true;
        }

        boolVar = false;
    }
    else
    {
        boolVar = true;
    }
}

int Misc::getGfxMode()
{
    bool mode[ 13 ]  = 
    { 
        resFullScreen,
        defaultScreen, defaultScreen, defaultScreen, defaultScreen,
        defaultScreen, defaultScreen, defaultScreen, defaultScreen,
        defaultBackupScreen, defaultBackupScreen, defaultBackupScreen, defaultBackupScreen
    };

    int depth[ 13 ] = 
    { 
        resDepth,
        32, 24, 16, 15,
        32, 24, 16, 15,
        32, 24, 16, 15,
    };

    int width[ 13 ]  = 
    { 
        resWidth,
        defaultWidth, defaultWidth, defaultWidth, defaultWidth,
        defaultBackupWidth, defaultBackupWidth, defaultBackupWidth, defaultBackupWidth,
        defaultBackupWidth, defaultBackupWidth , defaultBackupWidth, defaultBackupWidth
    };

    int height[ 13 ] = 
    { 
        resHeight,
        defaultHeight, defaultHeight, defaultHeight, defaultHeight,
        defaultBackupHeight, defaultBackupHeight, defaultBackupHeight, defaultBackupHeight,
        defaultBackupHeight, defaultBackupHeight, defaultBackupHeight, defaultBackupHeight
    };

    for ( int i = 0; i < 13; i++ )
    {
        if ( depth[ i ] == -1 )
        {
            set_color_depth( desktop_color_depth() );
        }
        else
        {
            set_color_depth( depth[ i ] );
        }
        if ( set_gfx_mode( ( mode[ i ] ? GFX_AUTODETECT_FULLSCREEN : GFX_AUTODETECT_WINDOWED ),
                            width[ i ], 
                            height[ i ],
                            0, 0 ) >= 0 )
        {
            resFullScreen   = mode[ i ];
            resDepth        = depth[ i ];
            resWidth        = width[ i ]; 
            resHeight       = height[ i ];

            return ER_NONE;
        }
    }

    return addError( ER_GRAPHICS_SET );
}

static bool get_config_bool( AL_CONST char *section, AL_CONST char *name, bool def )
{
    static char text[ 256 ];

    if ( stricmp( "true", get_config_string( section, name, text ) ) == 0 )
    {
        return true;
    }

    if ( stricmp( "false", get_config_string( section, name, text ) ) == 0 )
    {
        return false;
    }

    return def;
}

static void set_config_bool( AL_CONST char *section, AL_CONST char *name, bool val )
{
    set_config_string( section, name, ( val ? "true" : "false" ) );
}

void Misc::getConfig()
{
    strcpy( language, get_config_string( "System",  "language", defaultLanguage ) );

    resFullScreen   = get_config_bool("Graphics",  "fullscreen",     defaultScreen );
    resDepth        = get_config_int( "Graphics",  "depth",          defaultDepth );
    resWidth        = get_config_int( "Graphics",  "width",          defaultWidth);
    resHeight       = get_config_int( "Graphics",  "height",         defaultHeight );

    allowCheat      = get_config_bool( "Options", "allowcheat",     defaultAllowCheat );
    allowTicks      = get_config_bool( "Options", "allowtick",      defaultAllowTicks );
    showTime        = get_config_bool( "Options", "showtime",       defaultShowTime );
    showCorrect     = get_config_bool( "Options", "showcorrect",    defaultShowCorrect );
    showChoices     = get_config_bool( "Options", "showticks",      defaultShowChoices );

    strcpy( themeName, get_config_string( "Themes", "name",          defaultTheme ) );
}

void Misc::setConfig()
{
    set_config_string( "System",  "language",  language );

    set_config_bool( "Graphics",  "fullscreen",  resFullScreen );
    set_config_int( "Graphics",  "depth",       resDepth );
    set_config_int( "Graphics",  "width",       resWidth );
    set_config_int( "Graphics",  "height",      resHeight );

    set_config_bool( "Options", "allowcheat",   allowCheat );
    set_config_bool( "Options", "allowtick",    allowTicks );
    set_config_bool( "Options", "showtime",     showTime );
    set_config_bool( "Options", "showcorrect",  showCorrect );
    set_config_bool( "Options", "showticks",    showChoices );

    set_config_string( "Themes", "name",        themeName );
}


char *get_string( PACKFILE *pfile, char *string, int len )
{
    int index = 0;
    int c = '\0';

    for ( int i = 0; i < len; i++ )
    {
        string[ i ] = '\0';
    }

    if ( !pfile )
    {
        return string;
    }

    while ( true )
    {
        c = pack_getc( pfile );

        if ( c == '\r' )
        {
            c = pack_getc( pfile );
        }

        if ( c == EOF || c == '\n' )
        {
            break;
        }

        if ( c == '\\' )
        {
            c = pack_getc( pfile );
            switch ( c )
            {
            case 'n':
                {
                    c = '\n';
                } break;
            case '\\':
                {
                    c = '\\';
                } break;
            }
        }

        string[ index++ ] = c;
    }

    if ( need_uconvert( string, U_UTF8, U_CURRENT ) )
    {
        char stringBuffer[ 1024 ] = "";
        uconvert( string, U_UTF8, stringBuffer, U_CURRENT, sizeof( stringBuffer ) );
        ustrcpy( string, stringBuffer );
    }

    return string;
}

void Misc::getText()
{
    PACKFILE *pfile = NULL;  
    char path[ 1024 ];

    sprintf( path, langText, language );

    pfile = pack_fopen( path, "r" );

    for ( int i = 0; i < textTotalCount; i++ )
    {
        get_string( pfile, textList[ i ], sizeof( textList[ i ] ) );
    }

    if ( pfile )
    {
        pack_fclose( pfile );
    }
}

bool curPause = false;

void Misc::callIn()
{
    gamePaused = curPause;
}

void Misc::callOut()
{
    curPause = gamePaused;
}

