#ifdef _MSC_VER
#pragma warning( disable: 4312 )
#else
#define ALLEGRO_STATICLINK
#endif

#include <allegro.h>
#include "defines.h"
#include "boardcell.h"
#include "module.h"
#include "themefunctions.h"
#include "theme.h"
#include "globals.h"

BoardCell *selectedCell = NULL;
BoardCell *mouseOver = NULL;

BoardCell::BoardCell()
{
    this->solid         = false;
    this->value         = 0;
    this->actual        = 0;
    this->choiceCount   = 0;
    this->x             = 0;
    this->y             = 0;

    for ( int i = 0; i < gridSize; i++ )
    {
        this->choices[ i ] = 0;
        this->ticks[ i ] = 0;
    }
}

BoardCell::~BoardCell()
{
}

void BoardCell::save( PACKFILE *pfile )
{
    pack_putc( ( this->solid ? 1 : 0 ), pfile );
    pack_putc( this->value,             pfile );
    pack_putc( this->actual,            pfile );
    pack_putc( this->choiceCount,       pfile );
    pack_iputl( this->x,                pfile );
    pack_iputl( this->y,                pfile );

    for ( int i = 0; i < gridSize; i++ )
    {
        pack_putc( this->choices[ i ],  pfile );
        pack_putc( this->ticks[ i ],    pfile );
    }
}

void BoardCell::load( PACKFILE *pfile )
{
    this->solid         = ( pack_getc( pfile ) ? true : false );
    this->value         = pack_getc( pfile );
    this->actual        = pack_getc( pfile );
    this->choiceCount   = pack_getc( pfile );
    this->x             = pack_igetl( pfile );
    this->y             = pack_igetl( pfile );

    for ( int i = 0; i < gridSize; i++ )
    {
        this->choices[ i ] = pack_getc( pfile );
        this->ticks[ i ] = pack_getc( pfile );
    }
}


void BoardCell::addTick( char value )
{
    if ( value == 0 )
    {
        for ( int i = 0; i < gridSize; i++ )
        {
            this->ticks[ i ] = 0;
        }
    }
    else
    {
        for ( int i = 0; i < gridSize; i++ )
        {
            if ( this->ticks[ i ] == value )
            {
                this->ticks[ i ] = 0;
                return;
            }
        }

        for ( int i = 0; i < gridSize; i++ )
        {
            if ( this->ticks[ i ] == 0 )
            {
                this->ticks[ i ] = value;
                return;
            }
        }
    }
}

void BoardCell::setValue( char value )
{
    this->value     = value;
    this->choiceCount     = 0;

    for ( int i = 0; i < gridSize; i++ )
    {
        this->choices[ i ] = 0;
        this->ticks[ i ] = 0;
    }
}

void BoardCell::draw( BITMAP *bitmap )
{
    static int rectStyle = 0;
    static int textStyle = 0;


    rectStyle = R_NORMAL;
    textStyle = T_NORMAL;

    if ( gamePaused )
    {        
        theme.drawCell( bitmap, this->x, this->y, 0, rectStyle, textStyle );
    }
    else
    {
        if ( allowCheat )
        {
            if ( blockIndex > 0 )
            {
                bool yes = true;
                
                rectStyle = R_OVER;

                if ( !this->solid )
                {
                    for ( int i = 0; i < this->choiceCount; i++ )
                    {
                        if ( this->choices[ i ] == blockIndex )
                        {
                            yes = false;
                        }
                    }
                }

                if ( yes )
                {
                    rectStyle = R_BLOCK;

                    if ( this->value == blockIndex )
                    {
                        if ( this->solid )
                        {
                            textStyle = T_HIGHLIGHT;
                        }
                        rectStyle = R_NORMAL;
                    }
                }
                else
                {
                    rectStyle = R_NORMAL;
                }
            }
        }

        if ( this == selectedCell || 
            ( this == mouseOver && !selectedCell ) )
        {        
            rectStyle = R_OVER;
        }

        if ( this->value == 0 )
        {
        }
        else
        {
            if ( this->solid )
            {
                textStyle = T_SOLID;
            }
            else
            {
                if ( showCorrect && 
                    this->value == this->actual )
                {
                    textStyle = T_CORRECT;
                }
            }

            if ( rectStyle == R_OVER )
            {
                textStyle = T_HIGHLIGHT;
            }
        }

        theme.drawCell( bitmap, this->x, this->y, this->value, rectStyle, textStyle );

        if ( this->value == 0 )
        {
            if ( showChoices )
            {
#ifdef _DEBUG
                theme.drawTicks( bitmap, this->x, this->y, this->choices );
#else
                theme.drawTicks( bitmap, this->x, this->y, this->ticks );
#endif
            }
        }
    }
}

void BoardCell::drawSelection( BITMAP *bitmap )
{
    int length = 1 + this->choiceCount;
    int x1 = this->x + ( ( gameInfo.cell[ 0 ][ 0 ].rectInfo.width - gameInfo.board.selectWidth  ) / 2 );
    int x2 = x1 + gameInfo.board.selectWidth - 1;
    int yy = this->y + ( ( gameInfo.cell[ 0 ][ 0 ].rectInfo.height - gameInfo.board.selectHeight ) / 2 );
    int value = 0;
    static int rectStyle = 0;
    static int textStyle = 0;

    rectStyle = R_NORMAL;
    textStyle = T_NORMAL;

    if ( ( yy + ( length * gameInfo.board.selectHeight ) ) >= ( gameInfo.board.rectInfo.y + gameInfo.board.rectInfo.height ) )
    {
        yy = ( ( gameInfo.board.rectInfo.y + gameInfo.board.rectInfo.height ) - ( length * gameInfo.board.selectHeight ) );
    }

    for ( int i = 0; i < length; i++ )
    {
        int y1 = yy + i * gameInfo.board.selectHeight;
        int y2 = y1 + gameInfo.board.selectHeight;

        if ( mouseX >= x1 && mouseX < x2 &&
             mouseY >= y1 && mouseY < y2 )
        {
            rectStyle = R_SELECTIONOVER;
        }
        else
        {
            rectStyle = R_SELECTION;
        }

        if ( i > 0 )
        {
            value = ABS( this->choices[ i - 1 ] );
        }

        theme.drawSelection( bitmap, 
                             x1,
                             y1,
                             value,
                             rectStyle,
                             textStyle );
    }
}

int BoardCell::doSelection()
{
    int oldValue = this->value;
    int length = 1 + this->choiceCount;
    int x1 = this->x + ( ( gameInfo.cell[ 0 ][ 0 ].rectInfo.width - gameInfo.board.selectWidth ) / 2 );
    int x2 = x1 + gameInfo.board.selectWidth - 1;
    int yy = this->y + ( ( gameInfo.cell[ 0 ][ 0 ].rectInfo.height - gameInfo.board.selectHeight ) / 2 );
    int value = 0;

    if ( ( yy + ( length * gameInfo.board.selectHeight ) ) >= ( gameInfo.board.rectInfo.y + gameInfo.board.rectInfo.height ) )
    {
        yy = ( ( gameInfo.board.rectInfo.y + gameInfo.board.rectInfo.height ) - ( length * gameInfo.board.selectHeight ) );
    }


    for ( int i = 0; i < length; i++ )
    {
        int y1 = yy + i * gameInfo.board.selectHeight;
        int y2 = y1 + gameInfo.board.selectHeight;

        if ( mouseX >= x1 && mouseX < x2 &&
             mouseY >= y1 && mouseY < y2 )
        {
            if ( i > 0 )
            {
                value = ABS( this->choices[ i - 1 ] );
            }
        }
    }

    return value;
}

void BoardCell::doAddTick()
{
    int oldValue = this->value;
    int length = 1 + this->choiceCount;
    int x1 = this->x + ( ( gameInfo.cell[ 0 ][ 0 ].rectInfo.width - gameInfo.board.selectWidth ) / 2 );
    int x2 = x1 + gameInfo.board.selectWidth - 1;
    int yy = this->y + ( ( gameInfo.cell[ 0 ][ 0 ].rectInfo.height - gameInfo.board.selectHeight ) / 2 );

    if ( ( yy + ( length * gameInfo.board.selectHeight ) ) >= ( gameInfo.board.rectInfo.y + gameInfo.board.rectInfo.height ) )
    {
        yy = ( ( gameInfo.board.rectInfo.y + gameInfo.board.rectInfo.height ) - ( length * gameInfo.board.selectHeight ) );
    }


    for ( int i = 0; i < length; i++ )
    {
        int y1 = yy + i * gameInfo.board.selectHeight;
        int y2 = y1 + gameInfo.board.selectHeight;

        if ( mouseX >= x1 && mouseX < x2 &&
             mouseY >= y1 && mouseY < y2 )
        {
            if ( i == 0 )
            {
                addTick( 0 );
            }
            else
            {    
                addTick( this->choices[ i - 1 ] );
            }
        }
    }
}


bool BoardCell::isInside( int x, int y )
{
    return ( x >= this->x && 
             x < this->x + gameInfo.cell[ 0 ][ 0 ].rectInfo.width &&
             y >= this->y && 
             y < this->y + gameInfo.cell[ 0 ][ 0 ].rectInfo.height );
}

