#ifndef _GAME_H
#define _GAME_H

class Game
{
public:
    Game();
    ~Game();
    static int main( int argc, char **argv );

private:
    int init();
    void kill();
    void input();
    void processInput();
    void loop();
    void draw( BITMAP *bitmap );
    void logic();
    void saveGame();
    void loadGame();
    static void closeHook();
    void drawMouse( BITMAP *bitmap, int x, int y );
    int newGame( int difficulty );
    void doGameButton( int index );
    int doButtonLogic( ButtonInfo *buttonList, int start, int finish );

    int changeTheme( char *filename );
    
    void gameLogic();
    void mainMenuLogic();
    void OptionsMenuLogic();
    void themeMenuLogic();
    void questionLogic();

    void pauseGame();
    void unpauseGame();

    static bool done;
    static void secondCounterHandler();

    Board board;
    BITMAP *buffer;
    DATAFILE *datafile;
};


#endif

