/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/*-----------------------------------------------------------------------------\
|                                     ia.cpp                                   |
|       Ce module est responsable de l'intelligence artificielle               |
|                                                                              |
\-----------------------------------------------------------------------------*/

#include <allegro.h>
#include "ia.h"

int main(void)
{
allegro_init();

install_keyboard();

set_color_depth(32);
set_gfx_mode(GFX_AUTODETECT_WINDOWED,640,480,0,0);

clear(screen);

BRAIN brain;		// Un objet réseau de NEURON
int i;
int t_e=10;
int t_s=10;

brain.build(1,t_e,t_s,20);	// 2 étages, 2 entrées, 2 sorties

float test[10][t_e],t_r[10][t_s];

for(i=0;i<10;i++) {
/*	test[i][0]=((i&0x1)==1) ? 1.0f : 0.0f;
	test[i][1]=((i&0x2)==2) ? 1.0f : 0.0f;
	test[i][2]=((i&0x4)==4) ? 1.0f : 0.0f;
	test[i][3]=((i&0x8)==8) ? 1.0f : 0.0f;*/
	for(int e=0;e<10;e++)
		test[i][e]=0.0f;
	test[i][i]=1.0f;
	for(int e=0;e<10;e++)
		t_r[i][e]=0.0f;
	t_r[i][i]=1.0f;
	}
for(i=0;i<1000;i++)
	brain.mutation();

for(int e=0;e<100000;e++) {

	if(key[KEY_ESC])	e=10000000;


	for(int x=0;x<10;x++)
		for(i=0;i<x+1;i++) {
			brain.work(test[x]);
			brain.learn(t_r[x],0.01f);
			}
	for(int x=0;x<10;x++) {
		float *r;
		r=brain.work(test[x]);
		for(int k=0;k<t_e;k++)
			rectfill(screen,x*40,20+10*k,x*40+9,29+10*k,(int)(255*test[x][k])*0x010101);
		for(int k=0;k<t_s;k++) {
			rectfill(screen,x*40+10,20+10*k,x*40+19,29+10*k,(int)(255*t_r[x][k])*0x010101);
			line(screen,x*40+30,20+10*k,x*40+30,29+10*k,0x0000FF);
			rectfill(screen,x*40+20,20+10*k,x*40+29,29+10*k,(int)(255*r[k])*0x010101);
			}
		}
	textprintf(screen,font,0,0,0xFFFFFF,"e= %d",e);
	}

readkey();

allegro_exit();
return 0;
}
END_OF_MAIN();
