#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

char *progname;

#define BUFSIZE    1024

void fatal(char const *fmt, ...)
{
    char buf[BUFSIZE];
    va_list args;
    va_start( args, fmt );
    vsprintf( buf, fmt, args );
    fprintf(stderr, "%s: %s\n", progname, buf);
    va_end(args);

    exit(1);
}

void warning(char const *fmt, ...)
{
    char buf[BUFSIZE];
    va_list args;
    va_start( args, fmt );
    vsprintf( buf, fmt, args );
    fprintf(stderr, "%s: %s\n", progname, buf);
    va_end(args);
}

void usage()
{
    printf("usage: %s\n", progname);
    exit(1);
}
