#include "gun.h"
#include "draw.h"
#include "bullet.h"
#include "globals.h"

gun::gun(int _x, int _y, int _angle)
{
    ammo = 300;
    x = _x;
    y = _y;
    angle = _angle;
    fire_cost = 300;
    max_ammo = 500;
}

gun::~gun()
{
    // do nothing
}

// gun takes grid coordinates in columns and rows as parameters
int gun::fire(int tx, int ty)
{
    int lx, ly;
    
    if (ammo < fire_cost)
	return 0;

    ammo -= fire_cost;

    lx = x * COLS / SCREEN_W - (COLS - gr->get_w()) / 2;
    ly = y_offset + LINES - y * LINES / SCREEN_H;

    // pfah. make it leave FROM the gun not next to it. roundoff error?
    if (lx > 0)
	lx--;
    
    // create bullet and fire
    bullet *b = new bullet(lx, ly, tx, ty);
    // add to the bulls list
    add_bullet(b);
    
    return 1;
}
