#include <allegro.h>
#include <string.h>
#include "globals.h"
#include "draw.h"
#include "utils.h"
#include "data.h"

BITMAP *back;
BITMAP *dobj_bmps[dobj::DOBJ_LAST];
BITMAP *text_bmp;
BITMAP *mouse_bmp;
BITMAP *count_bmp;
BITMAP *name_bmp;
BITMAP *banner_bmp;
BITMAP *gun_bmp;

int init_graphics()
{
    int mousecol = makecol(80, 255, 40);

    text_mode(-1);

    banner_bmp = create_bitmap(SCREEN_W / 2, text_height(font) + 4);
    
    name_bmp = create_bitmap(SCREEN_W / 2, SCREEN_H /2);
    
    back = create_bitmap(SCREEN_W, SCREEN_H);
    clear_to_color(back, makecol(0, 0, 0));
    
    count_bmp = create_bitmap(text_length(font, "Time: 00000"), text_height(font));

    mouse_bmp = create_bitmap(SPACING, SPACING);
    clear_to_color(mouse_bmp, bitmap_mask_color(screen));
    line(mouse_bmp, SPACING / 2, 0, SPACING / 2, mouse_bmp->h -1, mousecol);
    line(mouse_bmp, SPACING / 2 - 1, 0, SPACING / 2 - 1, mouse_bmp->h -1,
	 mousecol);
    line(mouse_bmp, 0, SPACING / 2, mouse_bmp->w -1, SPACING / 2, mousecol);
    line(mouse_bmp, 0, SPACING / 2 - 1, mouse_bmp->w -1, SPACING / 2 - 1,
	 mousecol);
    set_mouse_sprite(mouse_bmp);
    show_mouse(back);

/*    
    gun_bmp = create_bitmap(SPACING * 3, SPACING * 3);
    clear_to_color(gun_bmp, bitmap_mask_color(screen));
    rectfill(gun_bmp,
	     0, gun_bmp->h / 2,
	     gun_bmp->w - 1, gun_bmp->h - 1,
	     makecol(50, 100, 50));
    rectfill(gun_bmp,
	     gun_bmp->w * 4 / 9, 0,
	     gun_bmp->w * 5 / 9, gun_bmp->h * 8 / 9,
	     makecol(100, 100, 100));
*/

    gun_bmp = (BITMAP *)(datafile[GUN_ID].dat);
    
    for (int d = 0; d < dobj::DOBJ_LAST; d++)
    {
	dobj_bmps[d] = create_bitmap(SPACING, SPACING);
	clear_to_color(dobj_bmps[d], bitmap_mask_color(screen));
    }

    
    /*
    clear_to_color(dobj_bmps[dobj::WALL], makecol(50, 50, 50));
    line(dobj_bmps[dobj::WALL], 0, 0, SPACING, 0, makecol(80, 80, 80));
    line(dobj_bmps[dobj::WALL], 0, 0, 0, SPACING, makecol(80, 80, 80));
    */

    blit((BITMAP *)(datafile[WALL_ID].dat), dobj_bmps[dobj::WALL],
	 0, 0, 0, 0, SPACING, SPACING);

    /*
    circlefill(dobj_bmps[dobj::BOULDER],
	       SPACING/2, SPACING/2, SPACING/2 -1,
	       makecol(150, 150, 150));
    */
	       
    blit((BITMAP *)(datafile[BOULDER_ID].dat), dobj_bmps[dobj::BOULDER],
	 0, 0, 0, 0, SPACING, SPACING);

    /*
    clear_to_color(dobj_bmps[dobj::TARGET], makecol(180, 0, 0));
    line(dobj_bmps[dobj::TARGET], 0, 0, SPACING, 0, makecol(120, 0, 0));
    line(dobj_bmps[dobj::TARGET], 0, 0, 0, SPACING, makecol(120, 0, 0));
    */
    
    blit((BITMAP *)(datafile[TARGET_ID].dat), dobj_bmps[dobj::TARGET],
	 0, 0, 0, 0, SPACING, SPACING);

    
    line(dobj_bmps[dobj::MAN],        // arms  ------
	 SPACING / 10, SPACING / 2, SPACING * 9 / 10, SPACING / 2,
	 makecol(255, 130, 100));
    line(dobj_bmps[dobj::MAN],        // leg /
	 SPACING / 2, SPACING / 2, SPACING / 10, SPACING * 9 / 10,
	 makecol(255, 130, 100));
    line(dobj_bmps[dobj::MAN],        /* leg \ */
	 SPACING / 2, SPACING / 2, SPACING * 9 / 10, SPACING * 9 / 10,
	 makecol(255, 130, 100));    
    circlefill(dobj_bmps[dobj::MAN],  // head   o
	 SPACING / 2, SPACING / 5, SPACING / 5 - 1,
	 makecol(255, 130, 100));    
    circlefill(dobj_bmps[dobj::MAN],  // body   O
	 SPACING / 2, SPACING / 2, SPACING / 4,
	 makecol(0, 0, 100));

    // don't draw placeholders

    /*
    clear_to_color(dobj_bmps[dobj::SAND], makecol(80, 60, 0));
    */
    
    blit((BITMAP *)(datafile[SAND_ID].dat), dobj_bmps[dobj::SAND],
	 0, 0, 0, 0, SPACING, SPACING);

    
    circlefill(dobj_bmps[dobj::BULLET], SPACING / 2, SPACING / 2,
	       SPACING / 6, makecol(100, 100, 255));
//    circlefill(dobj_bmps[dobj::BULLET], SPACING / 2, SPACING / 2,
//	       SPACING / 5, makecol(50, 50, 255));
    
    return 1;
}

int shutdown_graphics()
{
    warning("stop mouse");
    show_mouse(NULL);

    warning("destroy name bmp");
    destroy_bitmap(name_bmp);

    warning("destroy banner bmp");
    destroy_bitmap(banner_bmp);
    
    warning("destroy mouse_bmp");
    destroy_bitmap(mouse_bmp);

    warning("destroy count bmp");
    destroy_bitmap(count_bmp);
    
    warning("destroy back");
    destroy_bitmap(back);

    for (int d = 0; d < dobj::DOBJ_LAST; d++)
    {
	warning("destroy dobj_bmps[%d]", d);
	destroy_bitmap(dobj_bmps[d]);
    }

//    warning("destroy gun_bmp");
//    destroy_bitmap(gun_bmp);

    if (text_bmp)
    {
	warning("destroy text_bmp");
	destroy_bitmap(text_bmp);
    }

    return 1;
}

int reset_graphics()
{
    clear_to_color(back, makecol(0, 0, 0));
    return 1;
}

int draw(dobj *to_draw, int x, int y)
{
    masked_blit(dobj_bmps[to_draw->type()], back,
		0, 0, x - SPACING / 2, y - SPACING / 2,
		SPACING, SPACING);
    
    return 1;
}

int draw(gun *g)
{
    rotate_sprite(back, gun_bmp,
		  g->x - gun_bmp->w / 2,
		  g->y - gun_bmp->h / 2,
		  itofix(256 * g->angle / 360));

    return 1;
}

int draw(char const *str, int color)
{
    int w, h;

    w = SCREEN_W * 3 / 4;
    h = SCREEN_H / 3;
    
    text_bmp = create_bitmap(text_length(font, str),
			     text_height(font));
    clear_to_color(text_bmp, bitmap_mask_color(screen));

    textout(text_bmp, font, str, 0, 0, color);
    masked_stretch_blit(text_bmp, back,
		 0, 0, text_bmp->w, text_bmp->h,
		 (SCREEN_W - w) / 2,
		 (SCREEN_H - h) / 2,
		 w, h);

    destroy_bitmap(text_bmp);
    text_bmp = 0;
    
    return 1;
}

void draw_particles(bullet *b)
{
    int tx, ty;

    for (int p = 0; p < MAX_PARTICLES; p++)
    {
	tx = (int) (
	     ((COLS - gr->get_w())/2) * SPACING
	     + b->particles[p][0] * SPACING
	     + SPACING / 2 );
	ty = (int) (
	     SCREEN_H
	     - b->particles[p][1] * SPACING
	     - SPACING / 2
	     + y_offset * SPACING );

//	warning("particle %d at <%lf, %lf>", p, b->particles[p][0],
//		b->particles[p][1]);
	
	rectfill(back, tx, ty, tx+1, ty+1, makecol(150, 150, 255));
    }
}



int draw_frame()
{
    dobj *to_draw;
    int n_y = LINES;

    static int last_countdown = 0;
    
    // scare the mouse while drawing
    show_mouse(NULL);
    
    // draw grid
    
    // clear the back buffer
    /*
    clear_to_color(back, makecol(0, 0, 0));
    */

    blit((BITMAP *)(datafile[BACKGROUND].dat), back,
	 0, 0, 0, 0,
	 SCREEN_W, SCREEN_H);

    // draw onto backbuffer
    for (int x = 0; x < gr->get_w(); x++)
    {
	for (int y = y_offset; (y < y_offset + n_y && y < gr->get_h()); y++)
	{
	    int tx, ty;
	    
	    tx = ((COLS - gr->get_w())/2 + x) * SPACING + SPACING / 2;
	    ty = SCREEN_H - SPACING / 2 - (y - y_offset) * SPACING;
	    
//	    putpixel(back,
//		     tx,
//		     ty,
//		     makecol(255, 0, 0));

	    if (y < 0 || y >= gr->get_h())
		continue;
	    
	    if ((to_draw = gr->get(x,y)))
	    {
		if (to_draw->state() == dobj::MOVING)
		{
		    tx += (to_draw->to_x - to_draw->from_x) * 20 *
			to_draw->fraction / to_draw->speed;
		    ty -= (to_draw->to_y - to_draw->from_y) * 20 *
			to_draw->fraction / to_draw->speed;
		}
		
		draw(to_draw, tx, ty);
	    }
	}
    }

    // draw guns
    draw(guns[0]);
    draw(guns[1]);

    // draw bullets (not in grid so separate)
    bullet *b = (bullet *)bulls;
    while (b)
    {
	int tx, ty;
	
	tx = (int) (
	     ((COLS - gr->get_w())/2) * SPACING
	     + b->dx * SPACING
	     + SPACING / 2 );
	ty = (int) (
	     SCREEN_H
	     - b->dy * SPACING
	     - SPACING / 2
	     + y_offset * SPACING );

//	warning("bullet at %lf, %lf", b->dx, b->dy);
	
	// draw bullet
	draw(b, tx, ty);

        // draw particles
	draw_particles(b);
	
	b = (bullet *)b->next;
    }
    
    // draw game over, if needed
    if (game_over)
    {
	if (countdown)
	    draw("GAME OVER!!", makecol(200, 50, 50));
	else
	    draw("TIME UP!!", makecol(50, 50, 200));
    }

    // draw start count
    if (startcount)
    {
	int col;
	char buf[20];
	int n = 1 + startcount / 100;
	
	sprintf(buf, "  %d  ", n);

	if (n == 1)
	    col = makecol(0, 255, 0);
	if (n == 2)
	    col = makecol(220, 150, 0);
	if (n == 3)
	    col = makecol(220, 0, 0);
	    
	draw(buf, col);
    }
    
    // draw countdown
    if (last_countdown != countdown / 100)
    {
	char buf[10];
	
	last_countdown = countdown / 100;
	sprintf(buf, "Time: %d", last_countdown);
	clear_to_color(count_bmp, bitmap_mask_color(screen));
	textout(count_bmp, font, buf, 0, 0, makecol(150, 150, 100));
    }
    masked_blit(count_bmp, back, 0, 0, SCREEN_W/30, SCREEN_H/10, count_bmp->w, count_bmp->h);
    
    if (finished)
    {
	int col = makecol(200, 200, 50);
	
	if (finished < 200)
	    draw("FINISH!!", col);
	else
	{
	    char buf[5];
	    sprintf(buf, "  %d  ", 5 - finished / 100);
	    draw(buf, col);
	}
    }

    // draw the banner
    int edgecol = makecol(20, 20, 20);
    line(back, 0, 0, back->w - 1, 0, edgecol);
    line(back, 0, banner_bmp->h * 2 - 1, back->w - 1, banner_bmp->h * 2 - 1,
	 edgecol);

    stipple_banner_blit(banner_bmp, back);

//    stretch_blit(banner_bmp, back, 0, 0, banner_bmp->w, banner_bmp->h,
//		                   0, 0, back->w, banner_bmp->h * 2);
    
    // retrieve the mouse
    show_mouse(back);
    
    // blit backbuffer onto screen
    blit(back, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
    
    return 1;
}

void read_new_name(char *buf, int len)
{
    char mybuf[80];
    char mybuf2[120];
    int n = 0;

    while (keypressed())
	readkey();
    
    clear_to_color(name_bmp, makecol(0, 0, 0));
    rect(name_bmp, 0, 0, name_bmp->w - 1, name_bmp->h - 1,
	 makecol(100, 100, 150));

    int textcol = makecol(50, 50, 200);
    
    textout_centre(name_bmp, font, "New highscore!", name_bmp->w / 2, name_bmp->h / 3, textcol);

    textout_centre(name_bmp, font, "Please enter your name: ", name_bmp->w / 2, name_bmp->h / 2, textcol);

    sprintf(mybuf2, "-  -");
    textout_centre(name_bmp, font, mybuf2, name_bmp->w / 2, name_bmp->h * 2 / 3, textcol);
    
    text_mode(0);
    
    int c;
    char ch;
    while (1)
    {
	blit(name_bmp, screen,
	     0, 0,
	     (SCREEN_W - name_bmp->w) / 2,
	     (SCREEN_H - name_bmp->h) / 2,
	     name_bmp->w, name_bmp->h);
	
	c = readkey();
	if (c >> 8 == KEY_ENTER)
	{
	    mybuf[n] = '\0';
	    break;
	}

	if (c >> 8 == KEY_BACKSPACE)
	{
	    if (n > 0)
	    {	    
		n--;
		mybuf[n] = '\0';
		rectfill(name_bmp, 1, name_bmp->h * 2 / 3, name_bmp->w - 2, name_bmp->h - 2, makecol(0,0,0));
	    }
	}
	else
	if (n < 79)
	{
	    ch = c & 0xFF;
	    mybuf[n++] = ch;
	    mybuf[n] = '\0';
	}
	
	sprintf(mybuf2, "- %s -", mybuf);
	textout_centre(name_bmp, font, mybuf2, name_bmp->w / 2, name_bmp->h * 2 / 3, textcol);
    }

    strncpy(buf, mybuf, len - 1);
    buf[len - 1] = '\0';
    
    text_mode(-1);
}

// enlarge source image by factor 2, stippling it
// clear target bitmap first to your favourite color!
void stipple_banner_blit(BITMAP *source, BITMAP *target)
{
    for (int x = 0; x < source->w; x++)
    {
	for (int y = 0; y < source->h; y++)
	{
	    putpixel(target, x * 2, y * 2, getpixel(source, x, y));
	}
    }
}

void draw_banner_string(char const *str)
{
    int textcol = makecol(255, 50, 50);
    int fieldcol = makecol(20, 50, 20);

    clear_to_color(banner_bmp, fieldcol);
    textout(banner_bmp, font, str, 2, 2, textcol);
}
