#include <allegro.h>
#include "placehld.h"
#include "globals.h"
#include "dobj.h"

void kill_dobj(dobj *d)
{
    gr->set(d->x, d->y, 0);

    // empty space created: warn other objects
    d->wake_all(d->x, d->y, -10, -10);

    delete d;
}

dobj::dobj(int _type)
{
    dobj_type = _type;
    x = y = 0;
    next = 0;
    prev = 0;
    plch = plch2 = 0;
    am_awake = 0;
    from_x = 0;
    from_y = 0;
    to_x = 0;
    to_y = 0;
    speed = 0;
    fraction = 0;
    move_state = STILL;
    please_delete = 0;
    please_destroy = 0;
}

dobj::~dobj()
{
    next = 0;
    prev = 0;
    // virtual destructor, don't do anything
}

int dobj::wakeup()
{
    // put us in the active list
    // if we're already awake, don't do anything

    // don't really put us there, it messes up the active list while
    // traversing. put us in a separate list and add later

    // if we're in the process of being deleted, do not wake us up.
    // don't know if this is possible, but can't hurt.

    if (please_delete || please_destroy)
    {
	return 0;
    }
    
    if (!am_awake)
    {
	ASSERT(!next && !prev);
//	ASSERT(move_state == STILL);

	next = add_list;
	prev = 0;

	if (add_list)
	{
	    add_list->prev = this;
	}
	
	add_list = this;
	
	am_awake = 1;

	ASSERT(add_list == this);
	ASSERT(prev == 0);
	
	if (next)
	    ASSERT(next->prev == this);
    }

    return 0;
}

int dobj::sleep()
{
    // only work if we're awake
    // we're being removed from the list FROM OUTSIDE
    // this is because we don't have a prev pointer so it's inefficient
    // to remove from the list ourselves.
    
    if (am_awake)
    {
	am_awake = 0;
    }

    return 0;
}

int dobj::awake() const
{
    return am_awake;
}

int dobj::state() const
{
    return move_state;
}

int dobj::go()
{
    return SLEEP;
}

int dobj::type() const
{
    return dobj_type;
}

void dobj::wake_all(int x1, int y1, int x2, int y2)
{
    dobj *dtmp;
    
    for (int i = 0; i < DIR_LAST; i++)
    {
	int tx;
	int ty;

	tx = x1 + dirs[i][0];
	ty = y1 + dirs[i][1];

	if (tx < 0 || tx >= gr->get_w() || ty < 0 || ty >= gr->get_h())
	    continue;
	
	// wake up everything around from position
	if ((dtmp = gr->get(tx, ty)))
	{
	    if (dtmp != this)
		dtmp->wakeup();
	}

	tx = x2 + dirs[i][0];
	ty = y2 + dirs[i][1];
	
	if (tx < 0 || tx >= gr->get_w() || ty < 0 || ty >= gr->get_h())
	    continue;

	// also around to position
	if ((dtmp = gr->get(tx, ty)))
	{
	    if (dtmp != this)
		dtmp->wakeup();
	}
    }
}

// claim a single space
void dobj::claim_space(int x, int y)
{
    // not allowed to already have a placeholder when this is called
    ASSERT(!plch && !plch2);

    // the grid position HAS to be empty when this happens
    ASSERT(!gr->get(x, y));
    
    // place a new placeholder at specified coordinates
    plch = new place_holder();
    gr->set(x, y, plch);
}

// claim 2 spaces
void dobj::claim_space(int x, int y, int x2, int y2)
{
    // not allowed to already have a placeholder when this is called
    ASSERT(!plch && !plch2);

    // the grid position HAS to be empty when this happens
    ASSERT(!gr->get(x, y) && !gr->get(x2, y2));
    
    // place a new placeholder at specified coordinates
    plch = new place_holder();
    gr->set(x, y, plch);

    plch2 = new place_holder();
    gr->set(x2, y2, plch2);
}
