#ifndef _BULLET_H_
#define _BULLET_H_

#include "dobj.h"

#define BULLET_SPEED 180
#define MAX_PARTICLES 10

class bullet : public dobj
{
public:
    bullet(int _x, int _y, int _tx, int _ty);
    ~bullet();

    int go();
    int arrive();
    int explode();

    void move_particle(int p);
    
    int tx;
    int ty;

    double dx;
    double dy;

    double pmass;        // particle mass
    double dt;           // time step
    
    // particles consist of x, y, vx, vy
    // everything in grid coordinates
    double particles[MAX_PARTICLES][4];
};

int add_bullet(bullet *b);
int destroy_bullet(bullet *b);

#endif
